﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/cloudformation/CloudFormation_EXPORTS.h>
#include <aws/cloudformation/model/ResponseMetadata.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Xml {
class XmlDocument;
}  // namespace Xml
}  // namespace Utils
namespace CloudFormation {
namespace Model {
class StartResourceScanResult {
 public:
  AWS_CLOUDFORMATION_API StartResourceScanResult() = default;
  AWS_CLOUDFORMATION_API StartResourceScanResult(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
  AWS_CLOUDFORMATION_API StartResourceScanResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the resource scan. The format is
   * <code>arn:${Partition}:cloudformation:${Region}:${Account}:resourceScan/${Id}</code>.
   * An example is
   * <code>arn:aws:cloudformation:<i>us-east-1</i>:<i>123456789012</i>:resourceScan/<i>f5b490f7-7ed4-428a-aa06-31ff25db0772</i>
   * </code>.</p>
   */
  inline const Aws::String& GetResourceScanId() const { return m_resourceScanId; }
  template <typename ResourceScanIdT = Aws::String>
  void SetResourceScanId(ResourceScanIdT&& value) {
    m_resourceScanIdHasBeenSet = true;
    m_resourceScanId = std::forward<ResourceScanIdT>(value);
  }
  template <typename ResourceScanIdT = Aws::String>
  StartResourceScanResult& WithResourceScanId(ResourceScanIdT&& value) {
    SetResourceScanId(std::forward<ResourceScanIdT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const ResponseMetadata& GetResponseMetadata() const { return m_responseMetadata; }
  template <typename ResponseMetadataT = ResponseMetadata>
  void SetResponseMetadata(ResponseMetadataT&& value) {
    m_responseMetadataHasBeenSet = true;
    m_responseMetadata = std::forward<ResponseMetadataT>(value);
  }
  template <typename ResponseMetadataT = ResponseMetadata>
  StartResourceScanResult& WithResponseMetadata(ResponseMetadataT&& value) {
    SetResponseMetadata(std::forward<ResponseMetadataT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_resourceScanId;

  ResponseMetadata m_responseMetadata;
  bool m_resourceScanIdHasBeenSet = false;
  bool m_responseMetadataHasBeenSet = false;
};

}  // namespace Model
}  // namespace CloudFormation
}  // namespace Aws
