/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene102;

import java.io.IOException;
import org.apache.lucene.codecs.hnsw.FlatVectorsScorer;
import org.apache.lucene.codecs.lucene102.BinarizedByteVectorValues;
import org.apache.lucene.codecs.lucene102.Lucene102BinaryQuantizedVectorsWriter;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.VectorUtil;
import org.apache.lucene.util.hnsw.RandomVectorScorer;
import org.apache.lucene.util.hnsw.RandomVectorScorerSupplier;
import org.apache.lucene.util.hnsw.UpdateableRandomVectorScorer;
import org.apache.lucene.util.quantization.OptimizedScalarQuantizer;

public class Lucene102BinaryFlatVectorsScorer
implements FlatVectorsScorer {
    private final FlatVectorsScorer nonQuantizedDelegate;
    private static final float FOUR_BIT_SCALE = 0.06666667f;

    public Lucene102BinaryFlatVectorsScorer(FlatVectorsScorer nonQuantizedDelegate) {
        this.nonQuantizedDelegate = nonQuantizedDelegate;
    }

    @Override
    public RandomVectorScorerSupplier getRandomVectorScorerSupplier(VectorSimilarityFunction similarityFunction, KnnVectorValues vectorValues) throws IOException {
        if (vectorValues instanceof BinarizedByteVectorValues) {
            throw new UnsupportedOperationException("getRandomVectorScorerSupplier(VectorSimilarityFunction,RandomAccessVectorValues) not implemented for binarized format");
        }
        return this.nonQuantizedDelegate.getRandomVectorScorerSupplier(similarityFunction, vectorValues);
    }

    @Override
    public RandomVectorScorer getRandomVectorScorer(final VectorSimilarityFunction similarityFunction, KnnVectorValues vectorValues, float[] target) throws IOException {
        if (vectorValues instanceof BinarizedByteVectorValues) {
            final BinarizedByteVectorValues binarizedVectors = (BinarizedByteVectorValues)vectorValues;
            OptimizedScalarQuantizer quantizer = binarizedVectors.getQuantizer();
            float[] centroid = binarizedVectors.getCentroid();
            float[] copy = ArrayUtil.copyOfSubArray(target, 0, target.length);
            if (similarityFunction == VectorSimilarityFunction.COSINE) {
                VectorUtil.l2normalize(copy);
            }
            target = copy;
            byte[] initial = new byte[target.length];
            final byte[] quantized = new byte[4 * binarizedVectors.discretizedDimensions() / 8];
            final OptimizedScalarQuantizer.QuantizationResult queryCorrections = quantizer.scalarQuantize(target, initial, (byte)4, centroid);
            OptimizedScalarQuantizer.transposeHalfByte(initial, quantized);
            return new RandomVectorScorer.AbstractRandomVectorScorer(this, binarizedVectors){

                @Override
                public float score(int node) throws IOException {
                    return Lucene102BinaryFlatVectorsScorer.quantizedScore(quantized, queryCorrections, binarizedVectors, node, similarityFunction);
                }
            };
        }
        return this.nonQuantizedDelegate.getRandomVectorScorer(similarityFunction, vectorValues, target);
    }

    @Override
    public RandomVectorScorer getRandomVectorScorer(VectorSimilarityFunction similarityFunction, KnnVectorValues vectorValues, byte[] target) throws IOException {
        return this.nonQuantizedDelegate.getRandomVectorScorer(similarityFunction, vectorValues, target);
    }

    RandomVectorScorerSupplier getRandomVectorScorerSupplier(VectorSimilarityFunction similarityFunction, Lucene102BinaryQuantizedVectorsWriter.OffHeapBinarizedQueryVectorValues scoringVectors, BinarizedByteVectorValues targetVectors) {
        return new BinarizedRandomVectorScorerSupplier(scoringVectors, targetVectors, similarityFunction);
    }

    public String toString() {
        return "Lucene102BinaryFlatVectorsScorer(nonQuantizedDelegate=" + String.valueOf(this.nonQuantizedDelegate) + ")";
    }

    static float quantizedScore(byte[] quantizedQuery, OptimizedScalarQuantizer.QuantizationResult queryCorrections, BinarizedByteVectorValues targetVectors, int targetOrd, VectorSimilarityFunction similarityFunction) throws IOException {
        byte[] binaryCode = targetVectors.vectorValue(targetOrd);
        float qcDist = VectorUtil.int4BitDotProduct(quantizedQuery, binaryCode);
        OptimizedScalarQuantizer.QuantizationResult indexCorrections = targetVectors.getCorrectiveTerms(targetOrd);
        float x1 = indexCorrections.quantizedComponentSum();
        float ax = indexCorrections.lowerInterval();
        float lx = indexCorrections.upperInterval() - ax;
        float ay = queryCorrections.lowerInterval();
        float ly = (queryCorrections.upperInterval() - ay) * 0.06666667f;
        float y1 = queryCorrections.quantizedComponentSum();
        float score = ax * ay * (float)targetVectors.dimension() + ay * lx * x1 + ax * ly * y1 + lx * ly * qcDist;
        if (similarityFunction == VectorSimilarityFunction.EUCLIDEAN) {
            score = queryCorrections.additionalCorrection() + indexCorrections.additionalCorrection() - 2.0f * score;
            return Math.max(1.0f / (1.0f + score), 0.0f);
        }
        score += queryCorrections.additionalCorrection() + indexCorrections.additionalCorrection() - targetVectors.getCentroidDP();
        if (similarityFunction == VectorSimilarityFunction.MAXIMUM_INNER_PRODUCT) {
            return VectorUtil.scaleMaxInnerProductScore(score);
        }
        return Math.max((1.0f + score) / 2.0f, 0.0f);
    }

    static class BinarizedRandomVectorScorerSupplier
    implements RandomVectorScorerSupplier {
        private final Lucene102BinaryQuantizedVectorsWriter.OffHeapBinarizedQueryVectorValues queryVectors;
        private final BinarizedByteVectorValues targetVectors;
        private final VectorSimilarityFunction similarityFunction;

        BinarizedRandomVectorScorerSupplier(Lucene102BinaryQuantizedVectorsWriter.OffHeapBinarizedQueryVectorValues queryVectors, BinarizedByteVectorValues targetVectors, VectorSimilarityFunction similarityFunction) {
            this.queryVectors = queryVectors;
            this.targetVectors = targetVectors;
            this.similarityFunction = similarityFunction;
        }

        @Override
        public UpdateableRandomVectorScorer scorer() throws IOException {
            final BinarizedByteVectorValues targetVectors = this.targetVectors.copy();
            final Lucene102BinaryQuantizedVectorsWriter.OffHeapBinarizedQueryVectorValues queryVectors = this.queryVectors.copy();
            return new UpdateableRandomVectorScorer.AbstractUpdateableRandomVectorScorer(targetVectors){
                private OptimizedScalarQuantizer.QuantizationResult queryCorrections;
                private byte[] vector;
                {
                    super(values);
                    this.queryCorrections = null;
                    this.vector = null;
                }

                @Override
                public void setScoringOrdinal(int node) throws IOException {
                    this.queryCorrections = queryVectors.getCorrectiveTerms(node);
                    this.vector = queryVectors.vectorValue(node);
                }

                @Override
                public float score(int node) throws IOException {
                    if (this.vector == null || this.queryCorrections == null) {
                        throw new IllegalStateException("setScoringOrdinal was not called");
                    }
                    return Lucene102BinaryFlatVectorsScorer.quantizedScore(this.vector, this.queryCorrections, targetVectors, node, similarityFunction);
                }
            };
        }

        @Override
        public RandomVectorScorerSupplier copy() throws IOException {
            return new BinarizedRandomVectorScorerSupplier(this.queryVectors.copy(), this.targetVectors.copy(), this.similarityFunction);
        }
    }
}

