/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility.readconfig;

import java.util.logging.Level;
import java.util.logging.Logger;
import us.fatehi.utility.readconfig.ReadConfig;
import us.fatehi.utility.readconfig.SystemPropertiesConfig;
import us.fatehi.utility.string.StringFormat;

public final class SystemConfig
implements ReadConfig {
    private static final Logger LOGGER = Logger.getLogger(SystemConfig.class.getName());
    private final ReadConfig env = System::getenv;
    private final ReadConfig sysProp = new SystemPropertiesConfig();

    @Override
    public boolean containsKey(String key) {
        boolean containsKey = this.sysProp.containsKey(key) || this.env.containsKey(key);
        return containsKey;
    }

    @Override
    public String getStringValue(String key, String defaultValue) {
        String value = null;
        if (this.sysProp.containsKey(key)) {
            value = this.sysProp.getStringValue(key, defaultValue);
            LOGGER.log(Level.CONFIG, new StringFormat("Using system property for <%s>", key));
        } else if (this.env.containsKey(key)) {
            value = this.env.getStringValue(key, defaultValue);
            LOGGER.log(Level.CONFIG, new StringFormat("Using environmental variable for <%s>", key));
        } else {
            value = defaultValue;
        }
        if (value == null) {
            value = "";
        }
        value = value.strip();
        LOGGER.log(Level.CONFIG, new StringFormat("Configuration value <%s>=<%s>", key, value));
        return value;
    }
}

