/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.fields;

import java.util.Arrays;
import org.firebirdsql.gds.ng.fields.RowDescriptor;

public class RowValue {
    private static final byte[] NOT_INITIALIZED = new byte[0];
    public static final RowValue EMPTY_ROW_VALUE = new RowValue(0, false);
    private final byte[][] fieldData;

    private RowValue(int size, boolean markUninitialized) {
        this.fieldData = new byte[size][];
        if (markUninitialized) {
            Arrays.fill((Object[])this.fieldData, NOT_INITIALIZED);
        }
    }

    public final int getCount() {
        return this.fieldData.length;
    }

    public void setFieldData(int index, byte[] data) {
        this.fieldData[index] = data;
    }

    public final byte[] getFieldData(int index) {
        byte[] data = this.fieldData[index];
        return (byte[])(data != NOT_INITIALIZED ? data : null);
    }

    public void reset() {
        Arrays.fill((Object[])this.fieldData, NOT_INITIALIZED);
    }

    public boolean isDeletedRowMarker() {
        return false;
    }

    public final void initializeFields() {
        for (int idx = 0; idx < this.fieldData.length; ++idx) {
            if (this.fieldData[idx] != NOT_INITIALIZED) continue;
            this.fieldData[idx] = null;
        }
    }

    public final boolean isInitialized(int index) {
        return this.fieldData[index] != NOT_INITIALIZED;
    }

    public static RowValue defaultFor(RowDescriptor rowDescriptor) {
        int count = rowDescriptor.getCount();
        if (count == 0) {
            return EMPTY_ROW_VALUE;
        }
        return new RowValue(count, true);
    }

    public static RowValue of(RowDescriptor rowDescriptor, byte[] ... rowData) {
        int size = rowDescriptor.getCount();
        if (size != rowData.length) {
            throw new IllegalArgumentException("Expected RowDescriptor count and rowData length to be the same");
        }
        if (size == 0) {
            return EMPTY_ROW_VALUE;
        }
        RowValue rowValue = new RowValue(size, false);
        for (int i = 0; i < size; ++i) {
            rowValue.setFieldData(i, rowData[i]);
        }
        return rowValue;
    }

    public static RowValue deletedRowMarker(int count) {
        return new DeletedRowMarker(count);
    }

    public static RowValue of(byte[] ... rowData) {
        if (rowData.length == 0) {
            return EMPTY_ROW_VALUE;
        }
        RowValue newRowValue = new RowValue(rowData.length, false);
        for (int idx = 0; idx < rowData.length; ++idx) {
            newRowValue.setFieldData(idx, rowData[idx]);
        }
        return newRowValue;
    }

    public final RowValue deepCopy() {
        int size = this.getCount();
        if (this instanceof DeletedRowMarker) {
            return new DeletedRowMarker(size);
        }
        if (size == 0) {
            return EMPTY_ROW_VALUE;
        }
        RowValue newRowValue = new RowValue(size, false);
        for (int idx = 0; idx < size; ++idx) {
            byte[] value = this.fieldData[idx];
            if (value != null && value != NOT_INITIALIZED) {
                value = (byte[])value.clone();
            }
            newRowValue.fieldData[idx] = value;
        }
        return newRowValue;
    }

    private static final class DeletedRowMarker
    extends RowValue {
        private DeletedRowMarker(int size) {
            super(size, false);
        }

        @Override
        public void setFieldData(int index, byte[] data) {
            throw new UnsupportedOperationException("Deleted row marker should not be updated");
        }

        @Override
        public void reset() {
        }

        @Override
        public boolean isDeletedRowMarker() {
            return true;
        }
    }
}

