/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui;

import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.runtime.RunnableWithResult;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;

public abstract class UITask<RESULT>
extends RunnableWithResult<RESULT> {
    public final RESULT runWithResult() throws DBException {
        return this.runTask();
    }

    protected abstract RESULT runTask() throws DBException;

    public RESULT execute() {
        return (RESULT)UIUtils.syncExec(this);
    }

    public static <T> T run(final TaskExecutor<T> runnable) {
        return (T)new UITask<T>(){

            @Override
            protected T runTask() {
                try {
                    return runnable.run();
                }
                catch (Exception e) {
                    DBWorkbench.getPlatformUI().showError("Task error", "Internal error: task " + String.valueOf(runnable) + "' failed", (Throwable)e);
                    return null;
                }
            }
        }.execute();
    }

    public static interface TaskExecutor<T> {
        public T run() throws DBException;
    }
}

