/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AnnotationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.typeann.TargetInfo;
import org.jetbrains.java.decompiler.modules.decompiler.typeann.TypeAnnotation;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.attr.StructGeneralAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructInnerClassesAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructLocalVariableTableAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructLocalVariableTypeTableAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructTypeAnnotationAttribute;
import org.jetbrains.java.decompiler.struct.consts.ConstantPool;
import org.jetbrains.java.decompiler.struct.gen.Type;
import org.jetbrains.java.decompiler.util.DataInputFullStream;

public abstract class StructMember {
    protected int accessFlags;
    protected Map<String, StructGeneralAttribute> attributes;

    protected StructMember(int accessFlags, Map<String, StructGeneralAttribute> attributes) {
        this.accessFlags = accessFlags;
        this.attributes = attributes;
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public <T extends StructGeneralAttribute> T getAttribute(StructGeneralAttribute.Key<T> attribute) {
        StructGeneralAttribute t = this.attributes.get(attribute.name);
        return (T)t;
    }

    public boolean hasAttribute(StructGeneralAttribute.Key<?> attribute) {
        return this.attributes.containsKey(attribute.name);
    }

    public boolean hasModifier(int modifier) {
        StructClass struct;
        StructMember structMember;
        boolean result;
        boolean bl = result = (this.accessFlags & modifier) == modifier;
        if (!result && modifier == 8 && (structMember = this) instanceof StructClass && (struct = (StructClass)structMember).hasAttribute(StructGeneralAttribute.ATTRIBUTE_INNER_CLASSES)) {
            StructInnerClassesAttribute attr = struct.getAttribute(StructGeneralAttribute.ATTRIBUTE_INNER_CLASSES);
            for (StructInnerClassesAttribute.Entry entry : attr.getEntries()) {
                if (entry.innerName == null || !entry.innerName.equals(struct.qualifiedName)) continue;
                return (entry.accessFlags & 8) == 8;
            }
        }
        return result;
    }

    public boolean isSynthetic() {
        return this.hasModifier(4096) || this.hasAttribute(StructGeneralAttribute.ATTRIBUTE_SYNTHETIC);
    }

    protected abstract Type getType();

    public boolean memberAnnCollidesWithTypeAnnotation(AnnotationExprent typeAnnotationExpr) {
        Type type = this.getType();
        if (type == null) {
            return false;
        }
        Set typeAnnotations = TargetInfo.EmptyTarget.extract(this.getPossibleTypeAnnotationCollisions()).stream().map(typeAnnotation -> typeAnnotation.getAnnotationExpr()).collect(Collectors.toUnmodifiableSet());
        return typeAnnotations.contains(typeAnnotationExpr);
    }

    public boolean paramAnnCollidesWithTypeAnnotation(AnnotationExprent typeAnnotationExpr, int param) {
        Set typeAnnotations = TargetInfo.FormalParameterTarget.extract(this.getPossibleTypeAnnotationCollisions(), param).stream().map(typeAnnotation -> typeAnnotation.getAnnotationExpr()).collect(Collectors.toUnmodifiableSet());
        return typeAnnotations.contains(typeAnnotationExpr);
    }

    private List<TypeAnnotation> getPossibleTypeAnnotationCollisions() {
        return Arrays.stream(StructGeneralAttribute.TYPE_ANNOTATION_ATTRIBUTES).flatMap(attrKey -> {
            StructTypeAnnotationAttribute attribute = (StructTypeAnnotationAttribute)this.getAttribute((StructGeneralAttribute.Key)attrKey);
            if (attribute == null) {
                return Stream.empty();
            }
            return attribute.getAnnotations().stream();
        }).collect(Collectors.toList());
    }

    public static Map<String, StructGeneralAttribute> readAttributes(DataInputFullStream in, ConstantPool pool) throws IOException {
        int length = in.readUnsignedShort();
        HashMap<String, StructGeneralAttribute> attributes = new HashMap<String, StructGeneralAttribute>(length);
        for (int i = 0; i < length; ++i) {
            StructGeneralAttribute table;
            int nameIndex = in.readUnsignedShort();
            String name = pool.getPrimitiveConstant(nameIndex).getString();
            StructGeneralAttribute attribute = StructGeneralAttribute.createAttribute(name);
            int attLength = in.readInt();
            if (attribute == null) {
                in.discard(attLength);
                continue;
            }
            attribute.initContent(in, pool);
            if (StructGeneralAttribute.ATTRIBUTE_LOCAL_VARIABLE_TABLE.name.equals(name) && attributes.containsKey(name)) {
                table = (StructLocalVariableTableAttribute)attributes.get(name);
                ((StructLocalVariableTableAttribute)table).add((StructLocalVariableTableAttribute)attribute);
                continue;
            }
            if (StructGeneralAttribute.ATTRIBUTE_LOCAL_VARIABLE_TYPE_TABLE.name.equals(name) && attributes.containsKey(name)) {
                table = (StructLocalVariableTypeTableAttribute)attributes.get(name);
                ((StructLocalVariableTypeTableAttribute)table).add((StructLocalVariableTypeTableAttribute)attribute);
                continue;
            }
            attributes.put(name, attribute);
        }
        if (attributes.containsKey(StructGeneralAttribute.ATTRIBUTE_LOCAL_VARIABLE_TABLE.name) && attributes.containsKey(StructGeneralAttribute.ATTRIBUTE_LOCAL_VARIABLE_TYPE_TABLE.name)) {
            ((StructLocalVariableTableAttribute)attributes.get(StructGeneralAttribute.ATTRIBUTE_LOCAL_VARIABLE_TABLE.name)).mergeSignatures((StructLocalVariableTypeTableAttribute)attributes.get(StructGeneralAttribute.ATTRIBUTE_LOCAL_VARIABLE_TYPE_TABLE.name));
        }
        return attributes;
    }
}

