/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.function;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.ComplexExplanation;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.function.DocValues;
import org.apache.lucene.search.function.ValueSource;
import org.apache.lucene.util.ToStringUtils;

public class ValueSourceQuery
extends Query {
    ValueSource valSrc;

    public ValueSourceQuery(ValueSource valSrc) {
        this.valSrc = valSrc;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        return this;
    }

    public void extractTerms(Set terms) {
    }

    protected Weight createWeight(Searcher searcher) {
        return new ValueSourceWeight(searcher);
    }

    public String toString(String field) {
        return this.valSrc.toString() + ToStringUtils.boost(this.getBoost());
    }

    public boolean equals(Object o) {
        if (this.getClass() != o.getClass()) {
            return false;
        }
        ValueSourceQuery other = (ValueSourceQuery)o;
        return this.getBoost() == other.getBoost() && this.valSrc.equals(other.valSrc);
    }

    public int hashCode() {
        return this.getClass().hashCode() + this.valSrc.hashCode() ^ Float.floatToIntBits(this.getBoost());
    }

    private class ValueSourceScorer
    extends Scorer {
        private final IndexReader reader;
        private final ValueSourceWeight weight;
        private final int maxDoc;
        private final float qWeight;
        private int doc;
        private final DocValues vals;

        private ValueSourceScorer(Similarity similarity, IndexReader reader, ValueSourceWeight w) throws IOException {
            super(similarity);
            this.doc = -1;
            this.weight = w;
            this.qWeight = w.getValue();
            this.reader = reader;
            this.maxDoc = reader.maxDoc();
            this.vals = ValueSourceQuery.this.valSrc.getValues(reader);
        }

        public boolean next() throws IOException {
            do {
                ++this.doc;
                if (this.doc < this.maxDoc) continue;
                return false;
            } while (this.reader.isDeleted(this.doc));
            return true;
        }

        public int doc() {
            return this.doc;
        }

        public float score() throws IOException {
            return this.qWeight * this.vals.floatVal(this.doc);
        }

        public boolean skipTo(int target) throws IOException {
            this.doc = target - 1;
            return this.next();
        }

        public Explanation explain(int doc) throws IOException {
            float sc = this.qWeight * this.vals.floatVal(doc);
            ComplexExplanation result = new ComplexExplanation(true, sc, ValueSourceQuery.this.toString() + ", product of:");
            result.addDetail(this.vals.explain(doc));
            result.addDetail(new Explanation(ValueSourceQuery.this.getBoost(), "boost"));
            result.addDetail(new Explanation(this.weight.queryNorm, "queryNorm"));
            return result;
        }
    }

    private class ValueSourceWeight
    implements Weight {
        Similarity similarity;
        float queryNorm;
        float queryWeight;

        public ValueSourceWeight(Searcher searcher) {
            this.similarity = ValueSourceQuery.this.getSimilarity(searcher);
        }

        public Query getQuery() {
            return ValueSourceQuery.this;
        }

        public float getValue() {
            return this.queryWeight;
        }

        public float sumOfSquaredWeights() throws IOException {
            this.queryWeight = ValueSourceQuery.this.getBoost();
            return this.queryWeight * this.queryWeight;
        }

        public void normalize(float norm) {
            this.queryNorm = norm;
            this.queryWeight *= this.queryNorm;
        }

        public Scorer scorer(IndexReader reader) throws IOException {
            return new ValueSourceScorer(this.similarity, reader, this);
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            return this.scorer(reader).explain(doc);
        }
    }
}

