/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.diagnostic.DelegatingLogger;
import com.intellij.openapi.diagnostic.Logger;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.ErrorCode;
import org.jetbrains.idea.svn.commandLine.SvnBindException;

class SvnFilteringExceptionLogger
extends DelegatingLogger<Logger> {
    private static final long EXPIRATION = TimeUnit.SECONDS.toNanos(30L);
    private static final ErrorCode[] ourErrorsToFilter = new ErrorCode[]{ErrorCode.WC_UNSUPPORTED_FORMAT, ErrorCode.WC_CORRUPT, ErrorCode.WC_CORRUPT_TEXT_BASE, ErrorCode.WC_NOT_FILE, ErrorCode.WC_NOT_WORKING_COPY, ErrorCode.WC_PATH_NOT_FOUND};
    private final long[] myExpirationTime;

    SvnFilteringExceptionLogger(@NotNull Logger delegate) {
        if (delegate == null) {
            SvnFilteringExceptionLogger.$$$reportNull$$$0(0);
        }
        super(delegate);
        this.myExpirationTime = new long[ourErrorsToFilter.length];
    }

    public void debug(String message, @Nullable Throwable t) {
        if (this.report(t)) {
            super.debug(message, t);
        }
    }

    public void info(String message, @Nullable Throwable t) {
        if (this.report(t)) {
            super.info(message, t);
        }
    }

    public void warn(String message, @Nullable Throwable t) {
        if (this.report(t)) {
            super.warn(message, t);
        }
    }

    private boolean report(@Nullable Throwable t) {
        if (t instanceof SvnBindException) {
            for (int i = 0; i < ourErrorsToFilter.length; ++i) {
                ErrorCode key = ourErrorsToFilter[i];
                if (!((SvnBindException)((Object)t)).contains(key)) continue;
                long now = System.nanoTime();
                if (this.myExpirationTime[i] > now) {
                    return false;
                }
                this.myExpirationTime[i] = now + EXPIRATION;
                break;
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "org/jetbrains/idea/svn/SvnFilteringExceptionLogger", "<init>"));
    }
}

