/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import org.bouncycastle.crypto.fips.KMAC;
import org.bouncycastle.crypto.internal.DataLengthException;
import org.bouncycastle.crypto.internal.DerivationFunction;
import org.bouncycastle.crypto.internal.DerivationParameters;
import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.Mac;
import org.bouncycastle.crypto.internal.macs.HMac;
import org.bouncycastle.crypto.internal.params.KDFParameters;
import org.bouncycastle.crypto.internal.params.KeyParameterImpl;

class ConcatenationKDFGenerator
implements DerivationFunction {
    private final Mac mac;
    private Digest digest;
    private byte[] shared;
    private byte[] otherInfo;
    private int hLen;

    public ConcatenationKDFGenerator(Digest digest) {
        this.digest = digest;
        this.mac = null;
        this.hLen = digest.getDigestSize();
    }

    public ConcatenationKDFGenerator(Mac mac) {
        this.mac = mac;
        this.digest = null;
        this.hLen = mac.getMacSize();
    }

    @Override
    public void init(DerivationParameters derivationParameters) {
        if (derivationParameters instanceof KDFParameters) {
            KDFParameters kDFParameters = (KDFParameters)derivationParameters;
            this.shared = kDFParameters.getSharedSecret();
            this.otherInfo = kDFParameters.getIV();
            if (this.mac != null) {
                byte[] byArray = kDFParameters.getSalt();
                if (kDFParameters.getSalt() == null) {
                    if (this.mac instanceof HMac) {
                        byArray = new byte[((HMac)this.mac).getUnderlyingDigest().getByteLength()];
                    } else if (this.mac instanceof KMAC) {
                        byArray = new byte[((KMAC)this.mac).getByteLength() - 4];
                    } else {
                        throw new IllegalArgumentException("cannot recognise MAC");
                    }
                }
                this.mac.init(new KeyParameterImpl(byArray));
            }
        } else {
            throw new IllegalArgumentException("KDF parameters required for KDF generator");
        }
    }

    public Digest getDigest() {
        return this.digest;
    }

    private void ItoOSP(int n, byte[] byArray) {
        byArray[0] = (byte)(n >>> 24);
        byArray[1] = (byte)(n >>> 16);
        byArray[2] = (byte)(n >>> 8);
        byArray[3] = (byte)(n >>> 0);
    }

    @Override
    public int generateBytes(byte[] byArray, int n, int n2) throws DataLengthException, IllegalArgumentException {
        if (this.digest != null) {
            return this.digestGenerateBytes(byArray, n, n2);
        }
        return this.macGenerateBytes(byArray, n, n2);
    }

    public int digestGenerateBytes(byte[] byArray, int n, int n2) throws DataLengthException, IllegalArgumentException {
        if (byArray.length - n2 < n) {
            throw new DataLengthException("output buffer too small");
        }
        byte[] byArray2 = new byte[this.hLen];
        byte[] byArray3 = new byte[4];
        int n3 = 1;
        int n4 = 0;
        this.digest.reset();
        if (n2 > this.hLen) {
            do {
                this.ItoOSP(n3, byArray3);
                this.digest.update(byArray3, 0, byArray3.length);
                this.digest.update(this.shared, 0, this.shared.length);
                if (this.otherInfo != null) {
                    this.digest.update(this.otherInfo, 0, this.otherInfo.length);
                }
                this.digest.doFinal(byArray2, 0);
                System.arraycopy(byArray2, 0, byArray, n + n4, this.hLen);
                n4 += this.hLen;
            } while (n3++ < n2 / this.hLen);
        }
        if (n4 < n2) {
            this.ItoOSP(n3, byArray3);
            this.digest.update(byArray3, 0, byArray3.length);
            this.digest.update(this.shared, 0, this.shared.length);
            if (this.otherInfo != null) {
                this.digest.update(this.otherInfo, 0, this.otherInfo.length);
            }
            this.digest.doFinal(byArray2, 0);
            System.arraycopy(byArray2, 0, byArray, n + n4, n2 - n4);
        }
        return n2;
    }

    private int macGenerateBytes(byte[] byArray, int n, int n2) throws DataLengthException, IllegalArgumentException {
        if (byArray.length - n2 < n) {
            throw new DataLengthException("output buffer too small");
        }
        byte[] byArray2 = new byte[this.hLen];
        byte[] byArray3 = new byte[4];
        int n3 = 1;
        int n4 = 0;
        this.mac.reset();
        if (this.mac instanceof KMAC) {
            this.ItoOSP(n3, byArray3);
            this.mac.update(byArray3, 0, byArray3.length);
            this.mac.update(this.shared, 0, this.shared.length);
            if (this.otherInfo != null) {
                this.mac.update(this.otherInfo, 0, this.otherInfo.length);
            }
            return ((KMAC)this.mac).doFinal(byArray, n, n2);
        }
        if (n2 > this.hLen) {
            do {
                this.ItoOSP(n3, byArray3);
                this.mac.update(byArray3, 0, byArray3.length);
                this.mac.update(this.shared, 0, this.shared.length);
                if (this.otherInfo != null) {
                    this.mac.update(this.otherInfo, 0, this.otherInfo.length);
                }
                this.mac.doFinal(byArray2, 0);
                System.arraycopy(byArray2, 0, byArray, n + n4, this.hLen);
                n4 += this.hLen;
            } while (n3++ < n2 / this.hLen);
        }
        if (n4 < n2) {
            this.ItoOSP(n3, byArray3);
            this.mac.update(byArray3, 0, byArray3.length);
            this.mac.update(this.shared, 0, this.shared.length);
            if (this.otherInfo != null) {
                this.mac.update(this.otherInfo, 0, this.otherInfo.length);
            }
            this.mac.doFinal(byArray2, 0);
            System.arraycopy(byArray2, 0, byArray, n + n4, n2 - n4);
        }
        return n2;
    }
}

