/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateEbsBlockDeviceRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LaunchTemplateBlockDeviceMappingRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LaunchTemplateBlockDeviceMappingRequest> {
    private static final SdkField<String> DEVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceName").getter(LaunchTemplateBlockDeviceMappingRequest.getter(LaunchTemplateBlockDeviceMappingRequest::deviceName)).setter(LaunchTemplateBlockDeviceMappingRequest.setter(Builder::deviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceName").unmarshallLocationName("DeviceName").build()}).build();
    private static final SdkField<String> VIRTUAL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VirtualName").getter(LaunchTemplateBlockDeviceMappingRequest.getter(LaunchTemplateBlockDeviceMappingRequest::virtualName)).setter(LaunchTemplateBlockDeviceMappingRequest.setter(Builder::virtualName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VirtualName").unmarshallLocationName("VirtualName").build()}).build();
    private static final SdkField<LaunchTemplateEbsBlockDeviceRequest> EBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Ebs").getter(LaunchTemplateBlockDeviceMappingRequest.getter(LaunchTemplateBlockDeviceMappingRequest::ebs)).setter(LaunchTemplateBlockDeviceMappingRequest.setter(Builder::ebs)).constructor(LaunchTemplateEbsBlockDeviceRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ebs").unmarshallLocationName("Ebs").build()}).build();
    private static final SdkField<String> NO_DEVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NoDevice").getter(LaunchTemplateBlockDeviceMappingRequest.getter(LaunchTemplateBlockDeviceMappingRequest::noDevice)).setter(LaunchTemplateBlockDeviceMappingRequest.setter(Builder::noDevice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NoDevice").unmarshallLocationName("NoDevice").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_NAME_FIELD, VIRTUAL_NAME_FIELD, EBS_FIELD, NO_DEVICE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LaunchTemplateBlockDeviceMappingRequest.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String deviceName;
    private final String virtualName;
    private final LaunchTemplateEbsBlockDeviceRequest ebs;
    private final String noDevice;

    private LaunchTemplateBlockDeviceMappingRequest(BuilderImpl builder) {
        this.deviceName = builder.deviceName;
        this.virtualName = builder.virtualName;
        this.ebs = builder.ebs;
        this.noDevice = builder.noDevice;
    }

    public final String deviceName() {
        return this.deviceName;
    }

    public final String virtualName() {
        return this.virtualName;
    }

    public final LaunchTemplateEbsBlockDeviceRequest ebs() {
        return this.ebs;
    }

    public final String noDevice() {
        return this.noDevice;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebs());
        hashCode = 31 * hashCode + Objects.hashCode(this.noDevice());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchTemplateBlockDeviceMappingRequest)) {
            return false;
        }
        LaunchTemplateBlockDeviceMappingRequest other = (LaunchTemplateBlockDeviceMappingRequest)obj;
        return Objects.equals(this.deviceName(), other.deviceName()) && Objects.equals(this.virtualName(), other.virtualName()) && Objects.equals(this.ebs(), other.ebs()) && Objects.equals(this.noDevice(), other.noDevice());
    }

    public final String toString() {
        return ToString.builder((String)"LaunchTemplateBlockDeviceMappingRequest").add("DeviceName", (Object)this.deviceName()).add("VirtualName", (Object)this.virtualName()).add("Ebs", (Object)this.ebs()).add("NoDevice", (Object)this.noDevice()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeviceName": {
                return Optional.ofNullable(clazz.cast(this.deviceName()));
            }
            case "VirtualName": {
                return Optional.ofNullable(clazz.cast(this.virtualName()));
            }
            case "Ebs": {
                return Optional.ofNullable(clazz.cast(this.ebs()));
            }
            case "NoDevice": {
                return Optional.ofNullable(clazz.cast(this.noDevice()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DeviceName", DEVICE_NAME_FIELD);
        map.put("VirtualName", VIRTUAL_NAME_FIELD);
        map.put("Ebs", EBS_FIELD);
        map.put("NoDevice", NO_DEVICE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LaunchTemplateBlockDeviceMappingRequest, T> g) {
        return obj -> g.apply((LaunchTemplateBlockDeviceMappingRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String deviceName;
        private String virtualName;
        private LaunchTemplateEbsBlockDeviceRequest ebs;
        private String noDevice;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchTemplateBlockDeviceMappingRequest model) {
            this.deviceName(model.deviceName);
            this.virtualName(model.virtualName);
            this.ebs(model.ebs);
            this.noDevice(model.noDevice);
        }

        public final String getDeviceName() {
            return this.deviceName;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final String getVirtualName() {
            return this.virtualName;
        }

        public final void setVirtualName(String virtualName) {
            this.virtualName = virtualName;
        }

        @Override
        public final Builder virtualName(String virtualName) {
            this.virtualName = virtualName;
            return this;
        }

        public final LaunchTemplateEbsBlockDeviceRequest.Builder getEbs() {
            return this.ebs != null ? this.ebs.toBuilder() : null;
        }

        public final void setEbs(LaunchTemplateEbsBlockDeviceRequest.BuilderImpl ebs) {
            this.ebs = ebs != null ? ebs.build() : null;
        }

        @Override
        public final Builder ebs(LaunchTemplateEbsBlockDeviceRequest ebs) {
            this.ebs = ebs;
            return this;
        }

        public final String getNoDevice() {
            return this.noDevice;
        }

        public final void setNoDevice(String noDevice) {
            this.noDevice = noDevice;
        }

        @Override
        public final Builder noDevice(String noDevice) {
            this.noDevice = noDevice;
            return this;
        }

        public LaunchTemplateBlockDeviceMappingRequest build() {
            return new LaunchTemplateBlockDeviceMappingRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LaunchTemplateBlockDeviceMappingRequest> {
        public Builder deviceName(String var1);

        public Builder virtualName(String var1);

        public Builder ebs(LaunchTemplateEbsBlockDeviceRequest var1);

        default public Builder ebs(Consumer<LaunchTemplateEbsBlockDeviceRequest.Builder> ebs) {
            return this.ebs((LaunchTemplateEbsBlockDeviceRequest)((LaunchTemplateEbsBlockDeviceRequest.Builder)LaunchTemplateEbsBlockDeviceRequest.builder().applyMutation(ebs)).build());
        }

        public Builder noDevice(String var1);
    }
}

