/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.ThrowableRunnable;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VcsSynchronousProgressWrapper {
    private VcsSynchronousProgressWrapper() {
    }

    public static boolean wrap(@NotNull ThrowableRunnable<? extends VcsException> runnable, @NotNull Project project, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title) {
        boolean notCanceled;
        if (runnable == null) {
            VcsSynchronousProgressWrapper.$$$reportNull$$$0(0);
        }
        if (project == null) {
            VcsSynchronousProgressWrapper.$$$reportNull$$$0(1);
        }
        if (title == null) {
            VcsSynchronousProgressWrapper.$$$reportNull$$$0(2);
        }
        VcsException[] exc = new VcsException[1];
        Runnable process = () -> {
            try {
                runnable.run();
            }
            catch (VcsException e) {
                exc[0] = e;
            }
        };
        if (ApplicationManager.getApplication().isDispatchThread()) {
            notCanceled = ProgressManager.getInstance().runProcessWithProgressSynchronously(process, title, true, project);
        } else {
            process.run();
            notCanceled = true;
        }
        if (exc[0] != null) {
            AbstractVcsHelper.getInstance(project).showError(exc[0], title);
            return false;
        }
        return notCanceled;
    }

    @Nullable
    public static <T> T compute(@NotNull ThrowableComputable<T, ? extends VcsException> computable, @NotNull Project project, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title) {
        Ref ref;
        boolean notCanceled;
        if (computable == null) {
            VcsSynchronousProgressWrapper.$$$reportNull$$$0(3);
        }
        if (project == null) {
            VcsSynchronousProgressWrapper.$$$reportNull$$$0(4);
        }
        if (title == null) {
            VcsSynchronousProgressWrapper.$$$reportNull$$$0(5);
        }
        return (T)((notCanceled = VcsSynchronousProgressWrapper.wrap((ThrowableRunnable<? extends VcsException>)((ThrowableRunnable)() -> VcsSynchronousProgressWrapper.lambda$compute$1(ref = new Ref(), computable)), project, title)) ? ref.get() : null);
    }

    private static /* synthetic */ void lambda$compute$1(Ref ref, ThrowableComputable computable) throws VcsException {
        ref.set(computable.compute());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/ui/VcsSynchronousProgressWrapper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "wrap";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "compute";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

