/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.eel.impl.local;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.platform.eel.EelArchiveApi;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.EelPlatform;
import com.intellij.platform.eel.EelResult;
import com.intellij.platform.eel.EelTunnelsWindowsApi;
import com.intellij.platform.eel.EelUserWindowsInfo;
import com.intellij.platform.eel.fs.EelFileSystemApi;
import com.intellij.platform.eel.fs.LocalEelFileSystemWindowsApi;
import com.intellij.platform.eel.impl.fs.EelUserWindowsInfoImpl;
import com.intellij.platform.eel.impl.fs.WindowsNioBasedEelFileSystemApi;
import com.intellij.platform.eel.impl.local.EelLocalExecWindowsApi;
import com.intellij.platform.eel.impl.local.LocalEelApiImplKt;
import com.intellij.platform.eel.impl.local.LocalEelArchiveApiImpl;
import com.intellij.platform.eel.impl.local.tunnels.EelLocalTunnelsApiImpl;
import com.intellij.platform.eel.path.EelPath;
import com.intellij.platform.eel.provider.LocalEelDescriptor;
import com.intellij.platform.eel.provider.LocalWindowsEelApi;
import com.intellij.platform.eel.provider.utils.EelUtilsKt;
import com.intellij.util.system.CpuArch;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006\""}, d2={"Lcom/intellij/platform/eel/impl/local/LocalWindowsEelApiImpl;", "Lcom/intellij/platform/eel/provider/LocalWindowsEelApi;", "nioFs", "Ljava/nio/file/FileSystem;", "<init>", "(Ljava/nio/file/FileSystem;)V", "platform", "Lcom/intellij/platform/eel/EelPlatform$Windows;", "getPlatform", "()Lcom/intellij/platform/eel/EelPlatform$Windows;", "tunnels", "Lcom/intellij/platform/eel/EelTunnelsWindowsApi;", "getTunnels", "()Lcom/intellij/platform/eel/EelTunnelsWindowsApi;", "descriptor", "Lcom/intellij/platform/eel/EelDescriptor;", "getDescriptor", "()Lcom/intellij/platform/eel/EelDescriptor;", "exec", "Lcom/intellij/platform/eel/impl/local/EelLocalExecWindowsApi;", "getExec", "()Lcom/intellij/platform/eel/impl/local/EelLocalExecWindowsApi;", "userInfo", "Lcom/intellij/platform/eel/EelUserWindowsInfo;", "getUserInfo", "()Lcom/intellij/platform/eel/EelUserWindowsInfo;", "archive", "Lcom/intellij/platform/eel/EelArchiveApi;", "getArchive", "()Lcom/intellij/platform/eel/EelArchiveApi;", "fs", "Lcom/intellij/platform/eel/fs/LocalEelFileSystemWindowsApi;", "getFs", "()Lcom/intellij/platform/eel/fs/LocalEelFileSystemWindowsApi;", "intellij.platform.eel.impl"})
public final class LocalWindowsEelApiImpl
implements LocalWindowsEelApi {
    @NotNull
    private final EelPlatform.Windows platform;
    @NotNull
    private final EelLocalExecWindowsApi exec;
    @NotNull
    private final EelUserWindowsInfo userInfo;
    @NotNull
    private final EelArchiveApi archive;
    @NotNull
    private final LocalEelFileSystemWindowsApi fs;

    public LocalWindowsEelApiImpl(@NotNull FileSystem nioFs) {
        Intrinsics.checkNotNullParameter((Object)nioFs, (String)"nioFs");
        if (!SystemInfo.isWindows) {
            throw new IllegalStateException("Check failed.");
        }
        CpuArch cpuArch = CpuArch.CURRENT;
        Intrinsics.checkNotNullExpressionValue((Object)cpuArch, (String)"CURRENT");
        this.platform = new EelPlatform.Windows(EelUtilsKt.toEelArch((CpuArch)cpuArch));
        this.exec = new EelLocalExecWindowsApi();
        this.userInfo = new EelUserWindowsInfoImpl(LocalEelApiImplKt.access$getLocalUserHome());
        this.archive = LocalEelArchiveApiImpl.INSTANCE;
        EelUserWindowsInfo eelUserWindowsInfo = this.getUserInfo();
        this.fs = new WindowsNioBasedEelFileSystemApi(nioFs, eelUserWindowsInfo){
            private final EelDescriptor descriptor;
            {
                this.descriptor = (EelDescriptor)LocalEelDescriptor.INSTANCE;
            }

            public EelDescriptor getDescriptor() {
                return this.descriptor;
            }

            public Object createTemporaryDirectory(EelFileSystemApi.CreateTemporaryEntryOptions options, Continuation<? super EelResult<? extends EelPath, ? extends EelFileSystemApi.CreateTemporaryEntryError>> $completion) {
                return LocalEelApiImplKt.access$doCreateTemporaryDirectory(options);
            }

            public Object createTemporaryFile(EelFileSystemApi.CreateTemporaryEntryOptions options, Continuation<? super EelResult<? extends EelPath, ? extends EelFileSystemApi.CreateTemporaryEntryError>> $completion) {
                return LocalEelApiImplKt.access$doCreateTemporaryFile(options);
            }
        };
    }

    public /* synthetic */ LocalWindowsEelApiImpl(FileSystem fileSystem, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            FileSystem fileSystem2 = FileSystems.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)fileSystem2, (String)"getDefault(...)");
            fileSystem = fileSystem2;
        }
        this(fileSystem);
    }

    @NotNull
    public EelPlatform.Windows getPlatform() {
        return this.platform;
    }

    @NotNull
    public EelTunnelsWindowsApi getTunnels() {
        return EelLocalTunnelsApiImpl.INSTANCE;
    }

    @NotNull
    public EelDescriptor getDescriptor() {
        return (EelDescriptor)LocalEelDescriptor.INSTANCE;
    }

    @NotNull
    public EelLocalExecWindowsApi getExec() {
        return this.exec;
    }

    @NotNull
    public EelUserWindowsInfo getUserInfo() {
        return this.userInfo;
    }

    @NotNull
    public EelArchiveApi getArchive() {
        return this.archive;
    }

    @NotNull
    public LocalEelFileSystemWindowsApi getFs() {
        return this.fs;
    }

    public LocalWindowsEelApiImpl() {
        this(null, 1, null);
    }
}

