/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.variablesview.usertyperenderers;

import com.intellij.ide.util.ElementsChooser;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.QualifiedName;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.LabelPosition;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.table.JBTable;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.textCompletion.TextFieldWithCompletion;
import com.intellij.util.ui.JBUI;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.ui.XDebuggerExpressionEditor;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.debugger.PyDebuggerEditorsProvider;
import com.jetbrains.python.debugger.variablesview.usertyperenderers.PyUserNodeRenderer;
import com.jetbrains.python.debugger.variablesview.usertyperenderers.PyUserTypeRenderersSettings;
import com.jetbrains.python.debugger.variablesview.usertyperenderers.codeinsight.PyTypeNameResolver;
import com.jetbrains.python.debugger.variablesview.usertyperenderers.codeinsight.PyTypeNameResolverKt;
import com.jetbrains.python.debugger.variablesview.usertyperenderers.codeinsight.TypeNameCompletionProvider;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.impl.PyExpressionCodeFragmentImpl;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0002/0B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\u00172\b\u0010\u001b\u001a\u0004\u0018\u00010\u000bJ\b\u0010\u001c\u001a\u00020\tH\u0016J\b\u0010\u001d\u001a\u00020\u0017H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u0017H\u0016J\b\u0010!\u001a\u00020\u0017H\u0002J\b\u0010\"\u001a\u00020\u0005H\u0016J\b\u0010#\u001a\u00020\u0005H\u0016J\b\u0010$\u001a\u00020\u0005H\u0016J\b\u0010%\u001a\u00020\u0017H\u0002J\b\u0010&\u001a\u00020\u0017H\u0002J\u0010\u0010'\u001a\u00020\u00172\u0006\u0010(\u001a\u00020\u0005H\u0002J\u0016\u0010)\u001a\u00020\u00172\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u000b0+H\u0002J\u0012\u0010,\u001a\u00020\u00172\b\u0010\u001b\u001a\u0004\u0018\u00010\u000bH\u0002J\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00050+J\b\u0010.\u001a\u00020\u0017H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0018\u00010\u0011R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/jetbrains/python/debugger/variablesview/usertyperenderers/PyUserTypeRenderersConfigurable;", "Lcom/intellij/openapi/options/SearchableConfigurable;", "<init>", "()V", "CONFIGURABLE_ID", "", "PANEL_SPLIT_PROPORTION", "", "myMainPanel", "Ljavax/swing/JPanel;", "myCurrentRenderer", "Lcom/jetbrains/python/debugger/variablesview/usertyperenderers/PyUserNodeRenderer;", "myProject", "Lcom/intellij/openapi/project/Project;", "myRendererChooser", "Lcom/intellij/ide/util/ElementsChooser;", "myRendererSettings", "Lcom/jetbrains/python/debugger/variablesview/usertyperenderers/PyUserTypeRenderersConfigurable$RendererSettings;", "myRendererIndexToSelect", "", "Ljava/lang/Integer;", "myNewRendererToAdd", "setRendererIndexToSelect", "", "index", "(Ljava/lang/Integer;)V", "setNewRendererToAdd", "renderer", "createComponent", "reset", "isModified", "", "apply", "applyRenderersToDebugger", "getDisplayName", "getId", "getHelpTopic", "setupRendererChooser", "setupRendererSettings", "updateCurrentRendererName", "newName", "updateCurrentRenderer", "selectedElements", "", "setCurrentRenderer", "getCurrentlyVisibleNames", "disposeUIResources", "RendererChooserToolbarDecorator", "RendererSettings", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nPyUserTypeRenderersConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyUserTypeRenderersConfigurable.kt\ncom/jetbrains/python/debugger/variablesview/usertyperenderers/PyUserTypeRenderersConfigurable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,661:1\n1869#2,2:662\n*S KotlinDebug\n*F\n+ 1 PyUserTypeRenderersConfigurable.kt\ncom/jetbrains/python/debugger/variablesview/usertyperenderers/PyUserTypeRenderersConfigurable\n*L\n145#1:662,2\n*E\n"})
public final class PyUserTypeRenderersConfigurable
implements SearchableConfigurable {
    @NotNull
    private final String CONFIGURABLE_ID;
    private final float PANEL_SPLIT_PROPORTION;
    @NotNull
    private final JPanel myMainPanel = new JPanel(new BorderLayout());
    @Nullable
    private PyUserNodeRenderer myCurrentRenderer;
    @NotNull
    private final Project myProject;
    @NotNull
    private final ElementsChooser<PyUserNodeRenderer> myRendererChooser;
    @Nullable
    private RendererSettings myRendererSettings;
    @Nullable
    private Integer myRendererIndexToSelect;
    @Nullable
    private PyUserNodeRenderer myNewRendererToAdd;

    public PyUserTypeRenderersConfigurable() {
        Project project;
        this.CONFIGURABLE_ID = "debugger.dataViews.python.type.renderers";
        this.PANEL_SPLIT_PROPORTION = 0.3f;
        ProjectManager projectManager = ProjectManager.getInstance();
        Object[] objectArray = projectManager.getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getOpenProjects(...)");
        Object[] openProjects = objectArray;
        if (!(openProjects.length == 0)) {
            project = (Project)ArraysKt.first((Object[])openProjects);
        } else {
            Project project2 = projectManager.getDefaultProject();
            project = project2;
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getDefaultProject(...)");
        }
        this.myProject = project;
        this.myRendererChooser = new ElementsChooser(true);
    }

    public final void setRendererIndexToSelect(@Nullable Integer index) {
        this.myRendererIndexToSelect = index;
    }

    public final void setNewRendererToAdd(@Nullable PyUserNodeRenderer renderer) {
        this.myNewRendererToAdd = renderer;
    }

    @NotNull
    public JPanel createComponent() {
        ApplicationManager.getApplication().invokeLater(() -> PyUserTypeRenderersConfigurable.createComponent$lambda$0(this));
        return this.myMainPanel;
    }

    public void reset() {
        block5: {
            Object newRender;
            this.myRendererChooser.removeAllElements();
            this.myCurrentRenderer = null;
            PyUserTypeRenderersSettings settings = PyUserTypeRenderersSettings.getInstance();
            PyUserNodeRenderer newRendererToAdd = this.myNewRendererToAdd;
            if (newRendererToAdd != null) {
                newRender = newRendererToAdd.clone();
                this.myRendererChooser.addElement(newRender, ((PyUserNodeRenderer)newRender).isEnabled());
            }
            Iterator<PyUserNodeRenderer> iterator = settings.getRenderers().iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            newRender = iterator;
            while (newRender.hasNext()) {
                Object e = newRender.next();
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                PyUserNodeRenderer render = (PyUserNodeRenderer)e;
                PyUserNodeRenderer newRenderer = render.clone();
                this.myRendererChooser.addElement((Object)newRenderer, newRenderer.isEnabled());
            }
            List selectedRenderers = new ArrayList();
            Integer indexToSelect = this.myRendererIndexToSelect;
            if (indexToSelect != null && indexToSelect >= 0 && indexToSelect < this.myRendererChooser.getElementCount()) {
                PyUserNodeRenderer renderer = (PyUserNodeRenderer)this.myRendererChooser.getElementAt(indexToSelect.intValue());
                Intrinsics.checkNotNull((Object)renderer);
                selectedRenderers.add(renderer);
            } else if (this.myRendererChooser.getElementCount() != 0) {
                PyUserNodeRenderer firstRenderer = (PyUserNodeRenderer)this.myRendererChooser.getElementAt(0);
                Intrinsics.checkNotNull((Object)firstRenderer);
                selectedRenderers.add(firstRenderer);
            }
            this.myRendererChooser.selectElements((Collection)selectedRenderers);
            RendererSettings rendererSettings = this.myRendererSettings;
            if (rendererSettings == null) break block5;
            rendererSettings.reset();
        }
    }

    public boolean isModified() {
        RendererSettings rendererSettings = this.myRendererSettings;
        boolean bl = rendererSettings != null ? rendererSettings.isModified() : false;
        if (bl) {
            return true;
        }
        PyUserTypeRenderersSettings settings = PyUserTypeRenderersSettings.getInstance();
        if (this.myRendererChooser.getElementCount() != settings.getRenderers().size()) {
            return true;
        }
        ArrayList<PyUserNodeRenderer> arrayList = settings.getRenderers();
        Intrinsics.checkNotNullExpressionValue(arrayList, (String)"getRenderers(...)");
        Iterable $this$forEach$iv = CollectionsKt.withIndex((Iterable)arrayList);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IndexedValue it = (IndexedValue)element$iv;
            boolean bl2 = false;
            PyUserNodeRenderer element = (PyUserNodeRenderer)this.myRendererChooser.getElementAt(it.getIndex());
            Object object = it.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-value>(...)");
            if (element.equalTo((PyUserNodeRenderer)object)) continue;
            return true;
        }
        return false;
    }

    public void apply() {
        RendererSettings rendererSettings = this.myRendererSettings;
        if (rendererSettings != null) {
            rendererSettings.apply();
        }
        PyUserTypeRenderersSettings settings = PyUserTypeRenderersSettings.getInstance();
        List renderers = new ArrayList();
        int n = this.myRendererChooser.getElementCount();
        for (int i = 0; i < n; ++i) {
            PyUserNodeRenderer element = (PyUserNodeRenderer)this.myRendererChooser.getElementAt(i);
            renderers.add(element.clone());
        }
        settings.setRenderers(renderers);
        this.applyRenderersToDebugger();
    }

    private final void applyRenderersToDebugger() {
        block1: {
            XDebugSession debugSession;
            XDebugSession xDebugSession = debugSession = XDebuggerManager.getInstance((Project)this.myProject).getCurrentSession();
            XDebugProcess xDebugProcess = xDebugSession != null ? xDebugSession.getDebugProcess() : null;
            PyDebugProcess pyDebugProcess = xDebugProcess instanceof PyDebugProcess ? (PyDebugProcess)xDebugProcess : null;
            if (pyDebugProcess == null) break block1;
            PyDebugProcess debugProcess = pyDebugProcess;
            boolean bl = false;
            debugProcess.setUserTypeRenderersSettings();
            debugProcess.dropFrameCaches();
            XDebugSession xDebugSession2 = debugProcess.getSession();
            if (xDebugSession2 != null) {
                xDebugSession2.rebuildViews();
            }
        }
    }

    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("configurable.PyUserTypeRenderersConfigurable.display.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getId() {
        return this.CONFIGURABLE_ID;
    }

    @NotNull
    public String getHelpTopic() {
        return "reference.idesettings.debugger.typerenderers";
    }

    private final void setupRendererChooser() {
        this.myRendererChooser.getEmptyText().setText(PyBundle.message("form.debugger.variables.view.user.type.renderers.no.renderers", new Object[0]));
        this.myRendererChooser.addElementsMarkListener(PyUserTypeRenderersConfigurable::setupRendererChooser$lambda$0);
        this.myRendererChooser.addListSelectionListener(arg_0 -> PyUserTypeRenderersConfigurable.setupRendererChooser$lambda$1(this, arg_0));
    }

    private final void setupRendererSettings() {
        block0: {
            RendererSettings rendererSettings = this.myRendererSettings;
            if (rendererSettings == null) break block0;
            rendererSettings.setVisible(false);
        }
    }

    private final void updateCurrentRendererName(String newName) {
        block0: {
            PyUserNodeRenderer pyUserNodeRenderer = this.myCurrentRenderer;
            if (pyUserNodeRenderer == null) break block0;
            PyUserNodeRenderer it = pyUserNodeRenderer;
            boolean bl = false;
            it.setName(newName);
            this.myRendererChooser.refresh((Object)it);
        }
    }

    private final void updateCurrentRenderer(List<PyUserNodeRenderer> selectedElements) {
        if (selectedElements.size() == 1) {
            this.setCurrentRenderer(selectedElements.get(0));
        } else {
            this.setCurrentRenderer(null);
        }
    }

    private final void setCurrentRenderer(PyUserNodeRenderer renderer) {
        block4: {
            if (this.myCurrentRenderer == renderer) {
                return;
            }
            if (this.myRendererSettings == null) {
                return;
            }
            RendererSettings rendererSettings = this.myRendererSettings;
            boolean bl = rendererSettings != null ? rendererSettings.isModified() : false;
            if (bl) {
                RendererSettings rendererSettings2 = this.myRendererSettings;
                if (rendererSettings2 != null) {
                    rendererSettings2.apply();
                }
            }
            this.myCurrentRenderer = renderer;
            RendererSettings rendererSettings3 = this.myRendererSettings;
            if (rendererSettings3 == null) break block4;
            rendererSettings3.reset();
        }
    }

    @NotNull
    public final List<String> getCurrentlyVisibleNames() {
        List resultList = new ArrayList();
        int n = this.myRendererChooser.getElementCount();
        for (int i = 0; i < n; ++i) {
            Object object = (PyUserNodeRenderer)this.myRendererChooser.getElementAt(i);
            if (object == null || (object = ((PyUserNodeRenderer)object).getName()) == null) continue;
            Object name2 = object;
            boolean bl = false;
            resultList.add(name2);
        }
        return resultList;
    }

    public void disposeUIResources() {
        block0: {
            super.disposeUIResources();
            RendererSettings rendererSettings = this.myRendererSettings;
            if (rendererSettings == null) break block0;
            RendererSettings it = rendererSettings;
            boolean bl = false;
            ApplicationManager.getApplication().executeOnPooledThread(() -> PyUserTypeRenderersConfigurable.disposeUIResources$lambda$0$0(it));
        }
    }

    private static final void createComponent$lambda$0(PyUserTypeRenderersConfigurable this$0) {
        Splitter splitter;
        if (this$0.myProject.isDisposed()) {
            return;
        }
        this$0.myRendererSettings = this$0.new RendererSettings();
        this$0.setupRendererSettings();
        this$0.setupRendererChooser();
        ToolbarDecorator chooserDecorator = this$0.new RendererChooserToolbarDecorator().getDecorator();
        Splitter $this$createComponent_u24lambda_u240_u240 = splitter = new Splitter(false);
        boolean bl = false;
        $this$createComponent_u24lambda_u240_u240.setProportion(this$0.PANEL_SPLIT_PROPORTION);
        $this$createComponent_u24lambda_u240_u240.setFirstComponent((JComponent)chooserDecorator.createPanel());
        $this$createComponent_u24lambda_u240_u240.setSecondComponent((JComponent)this$0.myRendererSettings);
        Splitter splitter2 = splitter;
        if (this$0.myRendererChooser.getElementCount() > 0) {
            Integer n = this$0.myRendererIndexToSelect;
            int index = n != null ? n : 0;
            PyUserNodeRenderer first = (PyUserNodeRenderer)this$0.myRendererChooser.getElementAt(index);
            this$0.myRendererChooser.selectElements((Collection)CollectionsKt.listOf((Object)first));
        }
        this$0.myMainPanel.removeAll();
        Border border = IdeBorderFactory.createEmptyBorder((Insets)((Insets)JBUI.insets((int)10, (int)0)));
        String string = PyBundle.message("configurable.PyUserTypeRenderersConfigurable.description", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String message = string;
        this$0.myMainPanel.add((Component)JBUI.Panels.simplePanel((Component)((Component)new JBLabel(message))).withBorder(border), "North");
        this$0.myMainPanel.add((Component)splitter2, "Center");
    }

    private static final void setupRendererChooser$lambda$0(PyUserNodeRenderer element, boolean isMarked) {
        element.setEnabled(isMarked);
    }

    private static final void setupRendererChooser$lambda$1(PyUserTypeRenderersConfigurable this$0, ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            List list = this$0.myRendererChooser.getSelectedElements();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSelectedElements(...)");
            this$0.updateCurrentRenderer(list);
        }
    }

    private static final void disposeUIResources$lambda$0$0(RendererSettings $it) {
        Disposer.dispose((Disposable)$it);
    }

    public static final /* synthetic */ void access$updateCurrentRendererName(PyUserTypeRenderersConfigurable $this, String newName) {
        $this.updateCurrentRendererName(newName);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0082\u0004\u0018\u00002\u00020\u0001:\u0003\t\n\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\f"}, d2={"Lcom/jetbrains/python/debugger/variablesview/usertyperenderers/PyUserTypeRenderersConfigurable$RendererChooserToolbarDecorator;", "", "<init>", "(Lcom/jetbrains/python/debugger/variablesview/usertyperenderers/PyUserTypeRenderersConfigurable;)V", "decorator", "Lcom/intellij/ui/ToolbarDecorator;", "Lorg/jetbrains/annotations/NotNull;", "getDecorator", "()Lcom/intellij/ui/ToolbarDecorator;", "AddAction", "RemoveAction", "MoveAction", "intellij.python.community.impl"})
    private final class RendererChooserToolbarDecorator {
        @NotNull
        private final ToolbarDecorator decorator;

        public RendererChooserToolbarDecorator() {
            ToolbarDecorator toolbarDecorator = ToolbarDecorator.createDecorator((JComponent)PyUserTypeRenderersConfigurable.this.myRendererChooser.getComponent());
            Intrinsics.checkNotNullExpressionValue((Object)toolbarDecorator, (String)"createDecorator(...)");
            this.decorator = toolbarDecorator;
            this.decorator.setToolbarPosition(ActionToolbarPosition.TOP);
            this.decorator.setAddAction((AnActionButtonRunnable)new AddAction());
            this.decorator.setRemoveAction((AnActionButtonRunnable)new RemoveAction());
            this.decorator.setMoveUpAction((AnActionButtonRunnable)new MoveAction(true));
            this.decorator.setMoveDownAction((AnActionButtonRunnable)new MoveAction(false));
        }

        @NotNull
        public final ToolbarDecorator getDecorator() {
            return this.decorator;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/jetbrains/python/debugger/variablesview/usertyperenderers/PyUserTypeRenderersConfigurable$RendererChooserToolbarDecorator$AddAction;", "Lcom/intellij/ui/AnActionButtonRunnable;", "<init>", "(Lcom/jetbrains/python/debugger/variablesview/usertyperenderers/PyUserTypeRenderersConfigurable$RendererChooserToolbarDecorator;)V", "run", "", "button", "Lcom/intellij/ui/AnActionButton;", "intellij.python.community.impl"})
        private final class AddAction
        implements AnActionButtonRunnable {
            public void run(@Nullable AnActionButton button) {
                PyUserNodeRenderer renderer = new PyUserNodeRenderer(true, PyUserTypeRenderersConfigurable.this.getCurrentlyVisibleNames());
                PyUserTypeRenderersConfigurable.this.myRendererChooser.addElement((Object)renderer, renderer.isEnabled());
                PyUserTypeRenderersConfigurable.this.myRendererChooser.moveElement((Object)renderer, 0);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/jetbrains/python/debugger/variablesview/usertyperenderers/PyUserTypeRenderersConfigurable$RendererChooserToolbarDecorator$MoveAction;", "Lcom/intellij/ui/AnActionButtonRunnable;", "myMoveUp", "", "<init>", "(Lcom/jetbrains/python/debugger/variablesview/usertyperenderers/PyUserTypeRenderersConfigurable$RendererChooserToolbarDecorator;Z)V", "getMyMoveUp", "()Z", "run", "", "button", "Lcom/intellij/ui/AnActionButton;", "intellij.python.community.impl"})
        private final class MoveAction
        implements AnActionButtonRunnable {
            private final boolean myMoveUp;

            public MoveAction(boolean myMoveUp) {
                this.myMoveUp = myMoveUp;
            }

            public final boolean getMyMoveUp() {
                return this.myMoveUp;
            }

            public void run(@Nullable AnActionButton button) {
                int selectedRow = PyUserTypeRenderersConfigurable.this.myRendererChooser.getSelectedElementRow();
                if (selectedRow < 0) {
                    return;
                }
                int newRow = selectedRow + (this.myMoveUp ? -1 : 1);
                if (newRow < 0) {
                    newRow = PyUserTypeRenderersConfigurable.this.myRendererChooser.getElementCount() - 1;
                } else if (newRow >= PyUserTypeRenderersConfigurable.this.myRendererChooser.getElementCount()) {
                    newRow = 0;
                }
                PyUserTypeRenderersConfigurable.this.myRendererChooser.moveElement(PyUserTypeRenderersConfigurable.this.myRendererChooser.getElementAt(selectedRow), newRow);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/jetbrains/python/debugger/variablesview/usertyperenderers/PyUserTypeRenderersConfigurable$RendererChooserToolbarDecorator$RemoveAction;", "Lcom/intellij/ui/AnActionButtonRunnable;", "<init>", "(Lcom/jetbrains/python/debugger/variablesview/usertyperenderers/PyUserTypeRenderersConfigurable$RendererChooserToolbarDecorator;)V", "run", "", "button", "Lcom/intellij/ui/AnActionButton;", "intellij.python.community.impl"})
        @SourceDebugExtension(value={"SMAP\nPyUserTypeRenderersConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyUserTypeRenderersConfigurable.kt\ncom/jetbrains/python/debugger/variablesview/usertyperenderers/PyUserTypeRenderersConfigurable$RendererChooserToolbarDecorator$RemoveAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,661:1\n1869#2,2:662\n*S KotlinDebug\n*F\n+ 1 PyUserTypeRenderersConfigurable.kt\ncom/jetbrains/python/debugger/variablesview/usertyperenderers/PyUserTypeRenderersConfigurable$RendererChooserToolbarDecorator$RemoveAction\n*L\n251#1:662,2\n*E\n"})
        private final class RemoveAction
        implements AnActionButtonRunnable {
            /*
             * WARNING - void declaration
             */
            public void run(@Nullable AnActionButton button) {
                void $this$forEach$iv;
                List list = PyUserTypeRenderersConfigurable.this.myRendererChooser.getSelectedElements();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSelectedElements(...)");
                Iterable iterable = list;
                PyUserTypeRenderersConfigurable pyUserTypeRenderersConfigurable = PyUserTypeRenderersConfigurable.this;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    PyUserNodeRenderer it = (PyUserNodeRenderer)element$iv;
                    boolean bl = false;
                    pyUserTypeRenderersConfigurable.myRendererChooser.removeElement((Object)it);
                }
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\b\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002:\u000223B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u001a\u001a\u00020\u0001H\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001cH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020\u001cH\u0002J\b\u0010#\u001a\u00020\u001cH\u0002J\b\u0010$\u001a\u00020\u001cH\u0002J\b\u0010%\u001a\u00020\u0014H\u0002J\u0010\u0010&\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020\u001fH\u0016J\u0006\u0010(\u001a\u00020\u001fJ\u0006\u0010)\u001a\u00020\u001cJ\u0010\u0010*\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020\u001c2\u0006\u0010.\u001a\u00020,H\u0002J\u0010\u0010/\u001a\u00020\u001c2\u0006\u0010.\u001a\u00020,H\u0002J\u0006\u00100\u001a\u00020\u001cJ\b\u00101\u001a\u00020\u001cH\u0016R\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n0\u0016R\u00060\u0000R\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/jetbrains/python/debugger/variablesview/usertyperenderers/PyUserTypeRenderersConfigurable$RendererSettings;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/jetbrains/python/debugger/variablesview/usertyperenderers/PyUserTypeRenderersConfigurable;)V", "myPanel", "myRendererNameTextField", "Ljavax/swing/JTextField;", "myAppendDefaultChildrenCheckBox", "Ljavax/swing/JCheckBox;", "myRbDefaultValueRenderer", "Ljavax/swing/JRadioButton;", "myRbExpressionValueRenderer", "myRbDefaultChildrenRenderer", "myRbListChildrenRenderer", "myTypeNameTextField", "Lcom/intellij/util/textCompletion/TextFieldWithCompletion;", "myNodeValueExpressionEditor", "Lcom/intellij/xdebugger/impl/ui/XDebuggerExpressionEditor;", "myChildrenRenderersListEditor", "Ljavax/swing/JComponent;", "myChildrenListEditorTableModel", "Lcom/jetbrains/python/debugger/variablesview/usertyperenderers/PyUserTypeRenderersConfigurable$RendererSettings$ChildrenListEditorTableModel;", "Lcom/jetbrains/python/debugger/variablesview/usertyperenderers/PyUserTypeRenderersConfigurable;", "myChildrenListEditorTable", "Lcom/intellij/ui/table/JBTable;", "createSettingsPanel", "setupRendererNameField", "", "setupTypeNameEditor", "isValidTypeName", "", "typeName", "", "updateSelfType", "setupRadioButtons", "setupPanelComponents", "createChildrenListEditor", "setVisible", "aFlag", "isModified", "apply", "resetTypeInfo", "renderer", "Lcom/jetbrains/python/debugger/variablesview/usertyperenderers/PyUserNodeRenderer;", "resetChildrenListEditorTableModel", "currentRenderer", "resetRadioButtons", "reset", "dispose", "ChildrenListEditorToolbarDecorator", "ChildrenListEditorTableModel", "intellij.python.community.impl"})
    private final class RendererSettings
    extends JPanel
    implements Disposable {
        @NotNull
        private final JPanel myPanel;
        private JTextField myRendererNameTextField;
        private JCheckBox myAppendDefaultChildrenCheckBox;
        private JRadioButton myRbDefaultValueRenderer;
        private JRadioButton myRbExpressionValueRenderer;
        private JRadioButton myRbDefaultChildrenRenderer;
        private JRadioButton myRbListChildrenRenderer;
        @NotNull
        private final TextFieldWithCompletion myTypeNameTextField;
        @NotNull
        private final XDebuggerExpressionEditor myNodeValueExpressionEditor;
        @NotNull
        private final JComponent myChildrenRenderersListEditor;
        @NotNull
        private final ChildrenListEditorTableModel myChildrenListEditorTableModel;
        @NotNull
        private final JBTable myChildrenListEditorTable;

        public RendererSettings() {
            super(new BorderLayout());
            this.myTypeNameTextField = new TextFieldWithCompletion(PyUserTypeRenderersConfigurable.this.myProject, (TextCompletionProvider)new TypeNameCompletionProvider(PyUserTypeRenderersConfigurable.this.myProject), "", true, true, true);
            this.myNodeValueExpressionEditor = new XDebuggerExpressionEditor(PyUserTypeRenderersConfigurable.this.myProject, (XDebuggerEditorsProvider)new PyDebuggerEditorsProvider(), "NodeValueExpression", null, XExpressionImpl.EMPTY_EXPRESSION, false, false, true);
            this.myChildrenListEditorTableModel = new ChildrenListEditorTableModel();
            this.myChildrenListEditorTable = new JBTable((TableModel)this.myChildrenListEditorTableModel);
            this.myChildrenRenderersListEditor = this.createChildrenListEditor();
            this.setupTypeNameEditor();
            this.myPanel = this.createSettingsPanel();
            this.setupPanelComponents();
            this.add((Component)this.myPanel, "North");
        }

        private final JPanel createSettingsPanel() {
            return (JPanel)BuilderKt.panel(arg_0 -> RendererSettings.createSettingsPanel$lambda$0(this, arg_0));
        }

        private final void setupRendererNameField() {
            JTextField jTextField = this.myRendererNameTextField;
            if (jTextField == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myRendererNameTextField");
                jTextField = null;
            }
            jTextField.getDocument().addDocumentListener((javax.swing.event.DocumentListener)new DocumentAdapter(this, PyUserTypeRenderersConfigurable.this){
                final /* synthetic */ RendererSettings this$0;
                final /* synthetic */ PyUserTypeRenderersConfigurable this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                }

                protected void textChanged(DocumentEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    JTextField jTextField = RendererSettings.access$getMyRendererNameTextField$p(this.this$0);
                    if (jTextField == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"myRendererNameTextField");
                        jTextField = null;
                    }
                    String newName = jTextField.getText();
                    Intrinsics.checkNotNull((Object)newName);
                    PyUserTypeRenderersConfigurable.access$updateCurrentRendererName(this.this$1, newName);
                }
            });
        }

        private final void setupTypeNameEditor() {
            ComponentValidator myTypeNameFieldValidator = new ComponentValidator((Disposable)this).withValidator(() -> RendererSettings.setupTypeNameEditor$lambda$0(this)).installOn((JComponent)this.myTypeNameTextField);
            this.myTypeNameTextField.addFocusListener((FocusListener)new FocusAdapter(myTypeNameFieldValidator){
                final /* synthetic */ ComponentValidator $myTypeNameFieldValidator;
                {
                    this.$myTypeNameFieldValidator = $myTypeNameFieldValidator;
                }

                public void focusLost(FocusEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.$myTypeNameFieldValidator.revalidate();
                }
            });
            this.myTypeNameTextField.addDocumentListener(new DocumentListener(this){
                final /* synthetic */ RendererSettings this$0;
                {
                    this.this$0 = $receiver;
                }

                public void documentChanged(com.intellij.openapi.editor.event.DocumentEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    RendererSettings.access$updateSelfType(this.this$0);
                }
            });
        }

        private final boolean isValidTypeName(String typeName) {
            return new PyTypeNameResolver(PyUserTypeRenderersConfigurable.this.myProject).resolve(typeName) != null;
        }

        private final void updateSelfType() {
            String string = this.myTypeNameTextField.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String typeName = string;
            String moduleName = StringsKt.substringBeforeLast$default((String)typeName, (String)".", null, (int)2, null);
            String className = StringsKt.substringAfterLast$default((String)typeName, (String)".", null, (int)2, null);
            String string2 = Intrinsics.areEqual((Object)moduleName, (Object)className) ? "" : "from " + moduleName + " import " + className;
            String contextText = StringsKt.trimIndent((String)("\n        " + string2 + "\n        def foo(self: " + className + "):\n          pass\n        "));
            PyExpressionCodeFragmentImpl contextWithSelf = new PyExpressionCodeFragmentImpl(PyUserTypeRenderersConfigurable.this.myProject, "fragment.py", (CharSequence)contextText, true);
            int offset = StringsKt.indexOf$default((CharSequence)contextText, (String)"def", (int)0, (boolean)false, (int)6, null);
            XSourcePositionImpl srcPosition = XSourcePositionImpl.createByOffset((VirtualFile)contextWithSelf.getVirtualFile(), (int)offset);
            this.myNodeValueExpressionEditor.setSourcePosition((XSourcePosition)srcPosition);
        }

        private final void setupRadioButtons() {
            JRadioButton jRadioButton = this.myRbDefaultValueRenderer;
            if (jRadioButton == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myRbDefaultValueRenderer");
                jRadioButton = null;
            }
            jRadioButton.setSelected(true);
            JRadioButton jRadioButton2 = this.myRbDefaultChildrenRenderer;
            if (jRadioButton2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myRbDefaultChildrenRenderer");
                jRadioButton2 = null;
            }
            jRadioButton2.setSelected(true);
            ActionListener listener2 = arg_0 -> RendererSettings.setupRadioButtons$lambda$0(this, PyUserTypeRenderersConfigurable.this, arg_0);
            JRadioButton jRadioButton3 = this.myRbDefaultValueRenderer;
            if (jRadioButton3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myRbDefaultValueRenderer");
                jRadioButton3 = null;
            }
            jRadioButton3.addActionListener(listener2);
            JRadioButton jRadioButton4 = this.myRbExpressionValueRenderer;
            if (jRadioButton4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myRbExpressionValueRenderer");
                jRadioButton4 = null;
            }
            jRadioButton4.addActionListener(listener2);
            JRadioButton jRadioButton5 = this.myRbDefaultChildrenRenderer;
            if (jRadioButton5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myRbDefaultChildrenRenderer");
                jRadioButton5 = null;
            }
            jRadioButton5.addActionListener(listener2);
            JRadioButton jRadioButton6 = this.myRbListChildrenRenderer;
            if (jRadioButton6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myRbListChildrenRenderer");
                jRadioButton6 = null;
            }
            jRadioButton6.addActionListener(listener2);
        }

        private final void setupPanelComponents() {
            this.setupRendererNameField();
            this.setupRadioButtons();
            JCheckBox jCheckBox = this.myAppendDefaultChildrenCheckBox;
            if (jCheckBox == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myAppendDefaultChildrenCheckBox");
                jCheckBox = null;
            }
            jCheckBox.setEnabled(false);
            this.myChildrenListEditorTable.setEnabled(false);
        }

        private final JComponent createChildrenListEditor() {
            this.myChildrenListEditorTable.setShowGrid(true);
            JPanel jPanel = new ChildrenListEditorToolbarDecorator(this.myChildrenListEditorTable, this.myChildrenListEditorTableModel).getDecorator().createPanel();
            Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"createPanel(...)");
            return jPanel;
        }

        @Override
        public void setVisible(boolean aFlag) {
            this.myPanel.setVisible(aFlag);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isModified() {
            PyUserNodeRenderer pyUserNodeRenderer = PyUserTypeRenderersConfigurable.this.myCurrentRenderer;
            if (pyUserNodeRenderer == null) return false;
            PyUserNodeRenderer it = pyUserNodeRenderer;
            boolean bl = false;
            String string = it.getName();
            JTextField jTextField = this.myRendererNameTextField;
            if (jTextField == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myRendererNameTextField");
                jTextField = null;
            }
            if (!Intrinsics.areEqual((Object)string, (Object)jTextField.getText())) return true;
            if (!Intrinsics.areEqual((Object)it.getToType(), (Object)this.myTypeNameTextField.getText())) return true;
            boolean bl2 = it.getValueRenderer().isDefault();
            JRadioButton jRadioButton = this.myRbDefaultValueRenderer;
            if (jRadioButton == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myRbDefaultValueRenderer");
                jRadioButton = null;
            }
            if (bl2 != jRadioButton.isSelected()) return true;
            if (!Intrinsics.areEqual((Object)it.getValueRenderer().getExpression(), (Object)this.myNodeValueExpressionEditor.getExpression().getExpression())) return true;
            boolean bl3 = it.getChildrenRenderer().isDefault();
            JRadioButton jRadioButton2 = this.myRbDefaultChildrenRenderer;
            if (jRadioButton2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myRbDefaultChildrenRenderer");
                jRadioButton2 = null;
            }
            if (bl3 != jRadioButton2.isSelected()) return true;
            if (!Intrinsics.areEqual(it.getChildrenRenderer().getChildren(), this.myChildrenListEditorTableModel.getClonedChildren())) return true;
            boolean bl4 = it.getChildrenRenderer().getAppendDefaultChildren();
            JCheckBox jCheckBox = this.myAppendDefaultChildrenCheckBox;
            if (jCheckBox == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myAppendDefaultChildrenCheckBox");
                jCheckBox = null;
            }
            if (bl4 == jCheckBox.isSelected()) return false;
            return true;
        }

        public final void apply() {
            block4: {
                PyUserNodeRenderer pyUserNodeRenderer = PyUserTypeRenderersConfigurable.this.myCurrentRenderer;
                if (pyUserNodeRenderer == null) break block4;
                PyUserNodeRenderer it = pyUserNodeRenderer;
                boolean bl = false;
                JTextField jTextField = this.myRendererNameTextField;
                if (jTextField == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"myRendererNameTextField");
                    jTextField = null;
                }
                String string = jTextField.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                it.setName(string);
                String string2 = this.myTypeNameTextField.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                it.setToType(string2);
                PyUserNodeRenderer.PyNodeValueRenderer pyNodeValueRenderer = it.getValueRenderer();
                JRadioButton jRadioButton = this.myRbDefaultValueRenderer;
                if (jRadioButton == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"myRbDefaultValueRenderer");
                    jRadioButton = null;
                }
                pyNodeValueRenderer.setDefault(jRadioButton.isSelected());
                PyUserNodeRenderer.PyNodeValueRenderer pyNodeValueRenderer2 = it.getValueRenderer();
                String string3 = this.myNodeValueExpressionEditor.getExpression().getExpression();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getExpression(...)");
                pyNodeValueRenderer2.setExpression(string3);
                PyUserNodeRenderer.PyNodeChildrenRenderer pyNodeChildrenRenderer = it.getChildrenRenderer();
                JRadioButton jRadioButton2 = this.myRbDefaultChildrenRenderer;
                if (jRadioButton2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"myRbDefaultChildrenRenderer");
                    jRadioButton2 = null;
                }
                pyNodeChildrenRenderer.setDefault(jRadioButton2.isSelected());
                it.getChildrenRenderer().setChildren(this.myChildrenListEditorTableModel.getClonedChildren());
                PyUserNodeRenderer.PyNodeChildrenRenderer pyNodeChildrenRenderer2 = it.getChildrenRenderer();
                JCheckBox jCheckBox = this.myAppendDefaultChildrenCheckBox;
                if (jCheckBox == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"myAppendDefaultChildrenCheckBox");
                    jCheckBox = null;
                }
                pyNodeChildrenRenderer2.setAppendDefaultChildren(jCheckBox.isSelected());
                this.resetTypeInfo(it);
            }
        }

        private final void resetTypeInfo(PyUserNodeRenderer renderer) {
            QualifiedName importPath;
            renderer.setTypeSourceFile("");
            renderer.setModuleRootHasOneTypeWithSameName(false);
            String type2 = renderer.getToType();
            PyClass pyClass = new PyTypeNameResolver(PyUserTypeRenderersConfigurable.this.myProject).resolve(type2);
            if (pyClass == null) {
                return;
            }
            PyClass cls = pyClass;
            String string = cls.getName();
            if (string == null) {
                return;
            }
            String clsName = string;
            QualifiedName qualifiedName = importPath = QualifiedNameFinder.findCanonicalImportPath((PsiElement)((PsiElement)cls), null);
            renderer.setTypeCanonicalImportPath((String)(qualifiedName != null ? qualifiedName + "." + clsName : ""));
            String string2 = cls.getQualifiedName();
            if (string2 == null) {
                string2 = "";
            }
            renderer.setTypeQualifiedName(string2);
            Object object = cls.getContainingFile();
            if (object == null || (object = object.getVirtualFile()) == null || (object = object.getPath()) == null) {
                object = "";
            }
            renderer.setTypeSourceFile((String)object);
            QualifiedName qualifiedName2 = importPath;
            if (qualifiedName2 == null) {
                QualifiedName qualifiedName3 = QualifiedName.fromComponents((String[])new String[0]);
                qualifiedName2 = qualifiedName3;
                Intrinsics.checkNotNullExpressionValue((Object)qualifiedName3, (String)"fromComponents(...)");
            }
            renderer.setModuleRootHasOneTypeWithSameName(PyTypeNameResolverKt.getClassesNumberInModuleRootWithName(cls, qualifiedName2, PyUserTypeRenderersConfigurable.this.myProject) == 1);
        }

        private final void resetChildrenListEditorTableModel(PyUserNodeRenderer currentRenderer) {
            this.myChildrenListEditorTableModel.clear();
            for (PyUserNodeRenderer.ChildInfo child : currentRenderer.getChildrenRenderer().getChildren()) {
                this.myChildrenListEditorTableModel.addRow(child.getExpression());
            }
        }

        private final void resetRadioButtons(PyUserNodeRenderer currentRenderer) {
            if (currentRenderer.getValueRenderer().isDefault()) {
                JRadioButton jRadioButton = this.myRbDefaultValueRenderer;
                if (jRadioButton == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"myRbDefaultValueRenderer");
                    jRadioButton = null;
                }
                jRadioButton.doClick();
            } else {
                JRadioButton jRadioButton = this.myRbExpressionValueRenderer;
                if (jRadioButton == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"myRbExpressionValueRenderer");
                    jRadioButton = null;
                }
                jRadioButton.doClick();
            }
            if (currentRenderer.getChildrenRenderer().isDefault()) {
                JRadioButton jRadioButton = this.myRbDefaultChildrenRenderer;
                if (jRadioButton == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"myRbDefaultChildrenRenderer");
                    jRadioButton = null;
                }
                jRadioButton.doClick();
            } else {
                JRadioButton jRadioButton = this.myRbListChildrenRenderer;
                if (jRadioButton == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"myRbListChildrenRenderer");
                    jRadioButton = null;
                }
                jRadioButton.doClick();
            }
        }

        public final void reset() {
            PyUserNodeRenderer pyUserNodeRenderer = PyUserTypeRenderersConfigurable.this.myCurrentRenderer;
            if (pyUserNodeRenderer != null) {
                PyUserNodeRenderer it = pyUserNodeRenderer;
                boolean bl = false;
                JTextField jTextField = this.myRendererNameTextField;
                if (jTextField == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"myRendererNameTextField");
                    jTextField = null;
                }
                jTextField.setText(it.getName());
                this.myTypeNameTextField.setText(it.getToType());
                this.myNodeValueExpressionEditor.setExpression((XExpression)XExpressionImpl.fromText((String)it.getValueRenderer().getExpression()));
                JCheckBox jCheckBox = this.myAppendDefaultChildrenCheckBox;
                if (jCheckBox == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"myAppendDefaultChildrenCheckBox");
                    jCheckBox = null;
                }
                jCheckBox.setSelected(it.getChildrenRenderer().getAppendDefaultChildren());
                this.resetRadioButtons(it);
                this.resetChildrenListEditorTableModel(it);
                this.myPanel.setVisible(true);
            } else {
                RendererSettings $this$reset_u24lambda_u241 = this;
                boolean bl = false;
                $this$reset_u24lambda_u241.myPanel.setVisible(false);
            }
            this.updateSelfType();
        }

        public void dispose() {
        }

        private static final Unit createSettingsPanel$lambda$0(RendererSettings this$0, Panel $this$panel) {
            Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
            String string = PyBundle.message("form.debugger.variables.view.user.type.renderers.name", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            $this$panel.row(string, arg_0 -> RendererSettings.createSettingsPanel$lambda$0$0(this$0, arg_0));
            Panel.row$default((Panel)$this$panel, null, arg_0 -> RendererSettings.createSettingsPanel$lambda$0$1(this$0, arg_0), (int)1, null);
            Panel.buttonsGroup$default((Panel)$this$panel, (String)PyBundle.message("form.debugger.variables.view.user.type.renderers.when.rendering.node", new Object[0]), (boolean)false, arg_0 -> RendererSettings.createSettingsPanel$lambda$0$2(this$0, arg_0), (int)2, null);
            Panel.buttonsGroup$default((Panel)$this$panel, (String)PyBundle.message("form.debugger.variables.view.user.type.renderers.when.expanding.node", new Object[0]), (boolean)false, arg_0 -> RendererSettings.createSettingsPanel$lambda$0$3(this$0, arg_0), (int)2, null);
            return Unit.INSTANCE;
        }

        private static final Unit createSettingsPanel$lambda$0$0(RendererSettings this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            this$0.myRendererNameTextField = (JTextField)$this$row.textField().align((Align)AlignX.FILL.INSTANCE).getComponent();
            return Unit.INSTANCE;
        }

        private static final Unit createSettingsPanel$lambda$0$1(RendererSettings this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            Cell cell = $this$row.cell((JComponent)this$0.myTypeNameTextField);
            String string = PyBundle.message("form.debugger.variables.view.user.type.renderers.apply.renderer.to.objects.of.type", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            cell.label(string, LabelPosition.TOP).align((Align)AlignX.FILL.INSTANCE);
            return Unit.INSTANCE;
        }

        private static final Unit createSettingsPanel$lambda$0$2(RendererSettings this$0, Panel $this$buttonsGroup) {
            Intrinsics.checkNotNullParameter((Object)$this$buttonsGroup, (String)"$this$buttonsGroup");
            Panel.row$default((Panel)$this$buttonsGroup, null, arg_0 -> RendererSettings.createSettingsPanel$lambda$0$2$0(this$0, arg_0), (int)1, null);
            Panel.row$default((Panel)$this$buttonsGroup, null, arg_0 -> RendererSettings.createSettingsPanel$lambda$0$2$1(this$0, arg_0), (int)1, null);
            $this$buttonsGroup.indent(arg_0 -> RendererSettings.createSettingsPanel$lambda$0$2$2(this$0, arg_0));
            return Unit.INSTANCE;
        }

        private static final Unit createSettingsPanel$lambda$0$2$0(RendererSettings this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            String string = PyBundle.message("form.debugger.variables.view.user.type.renderers.use.default.renderer", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            this$0.myRbDefaultValueRenderer = (JRadioButton)Row.radioButton$default((Row)$this$row, (String)string, null, (int)2, null).getComponent();
            return Unit.INSTANCE;
        }

        private static final Unit createSettingsPanel$lambda$0$2$1(RendererSettings this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            String string = PyBundle.message("form.debugger.variables.view.user.type.renderers.use.following.expression", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            this$0.myRbExpressionValueRenderer = (JRadioButton)Row.radioButton$default((Row)$this$row, (String)string, null, (int)2, null).getComponent();
            return Unit.INSTANCE;
        }

        private static final Unit createSettingsPanel$lambda$0$2$2(RendererSettings this$0, Panel $this$indent) {
            Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
            Panel.row$default((Panel)$this$indent, null, arg_0 -> RendererSettings.createSettingsPanel$lambda$0$2$2$0(this$0, arg_0), (int)1, null);
            return Unit.INSTANCE;
        }

        private static final Unit createSettingsPanel$lambda$0$2$2$0(RendererSettings this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            JComponent jComponent = this$0.myNodeValueExpressionEditor.getComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
            Cell.comment$default((Cell)$this$row.cell(jComponent).align((Align)AlignX.FILL.INSTANCE), (String)PyBundle.message("form.debugger.variables.view.user.type.renderers.variable.name", new Object[0]), (int)0, null, (int)6, null);
            return Unit.INSTANCE;
        }

        private static final Unit createSettingsPanel$lambda$0$3(RendererSettings this$0, Panel $this$buttonsGroup) {
            Intrinsics.checkNotNullParameter((Object)$this$buttonsGroup, (String)"$this$buttonsGroup");
            Panel.row$default((Panel)$this$buttonsGroup, null, arg_0 -> RendererSettings.createSettingsPanel$lambda$0$3$0(this$0, arg_0), (int)1, null);
            Panel.row$default((Panel)$this$buttonsGroup, null, arg_0 -> RendererSettings.createSettingsPanel$lambda$0$3$1(this$0, arg_0), (int)1, null);
            $this$buttonsGroup.indent(arg_0 -> RendererSettings.createSettingsPanel$lambda$0$3$2(this$0, arg_0));
            return Unit.INSTANCE;
        }

        private static final Unit createSettingsPanel$lambda$0$3$0(RendererSettings this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            String string = PyBundle.message("form.debugger.variables.view.user.type.renderers.use.default.renderer", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            this$0.myRbDefaultChildrenRenderer = (JRadioButton)Row.radioButton$default((Row)$this$row, (String)string, null, (int)2, null).getComponent();
            return Unit.INSTANCE;
        }

        private static final Unit createSettingsPanel$lambda$0$3$1(RendererSettings this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            String string = PyBundle.message("form.debugger.variables.view.user.type.renderers.use.list.of.expressions", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            this$0.myRbListChildrenRenderer = (JRadioButton)Row.radioButton$default((Row)$this$row, (String)string, null, (int)2, null).getComponent();
            return Unit.INSTANCE;
        }

        private static final Unit createSettingsPanel$lambda$0$3$2(RendererSettings this$0, Panel $this$indent) {
            Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
            Panel.row$default((Panel)$this$indent, null, arg_0 -> RendererSettings.createSettingsPanel$lambda$0$3$2$0(this$0, arg_0), (int)1, null);
            Panel.row$default((Panel)$this$indent, null, arg_0 -> RendererSettings.createSettingsPanel$lambda$0$3$2$1(this$0, arg_0), (int)1, null);
            return Unit.INSTANCE;
        }

        private static final Unit createSettingsPanel$lambda$0$3$2$0(RendererSettings this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            Cell.comment$default((Cell)$this$row.cell(this$0.myChildrenRenderersListEditor).align((Align)AlignX.FILL.INSTANCE), (String)PyBundle.message("form.debugger.variables.view.user.type.renderers.variable.name", new Object[0]), (int)0, null, (int)6, null);
            return Unit.INSTANCE;
        }

        private static final Unit createSettingsPanel$lambda$0$3$2$1(RendererSettings this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            String string = PyBundle.message("form.debugger.variables.view.user.type.renderers.append.default.children", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            this$0.myAppendDefaultChildrenCheckBox = (JCheckBox)$this$row.checkBox(string).getComponent();
            return Unit.INSTANCE;
        }

        private static final ValidationInfo setupTypeNameEditor$lambda$0(RendererSettings this$0) {
            String string = this$0.myTypeNameTextField.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String text = string;
            return !this$0.isValidTypeName(text) ? new ValidationInfo(PyBundle.message("form.debugger.variables.view.user.type.renderers.class.not.found", new Object[0]), (JComponent)this$0.myTypeNameTextField) : null;
        }

        private static final void setupRadioButtons$lambda$0(RendererSettings this$0, PyUserTypeRenderersConfigurable this$1, ActionEvent e) {
            block11: {
                JRadioButton jRadioButton;
                Object object;
                block10: {
                    JRadioButton jRadioButton2;
                    object = e.getSource();
                    JRadioButton jRadioButton3 = this$0.myRbDefaultChildrenRenderer;
                    if (jRadioButton3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"myRbDefaultChildrenRenderer");
                        jRadioButton3 = null;
                    }
                    if (!Intrinsics.areEqual((Object)object, (Object)jRadioButton3)) break block10;
                    JCheckBox jCheckBox = this$0.myAppendDefaultChildrenCheckBox;
                    if (jCheckBox == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"myAppendDefaultChildrenCheckBox");
                        jCheckBox = null;
                    }
                    if ((jRadioButton2 = this$0.myRbListChildrenRenderer) == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"myRbListChildrenRenderer");
                        jRadioButton2 = null;
                    }
                    jCheckBox.setEnabled(jRadioButton2.isSelected());
                    JBTable jBTable = this$0.myChildrenListEditorTable;
                    JRadioButton jRadioButton4 = this$0.myRbListChildrenRenderer;
                    if (jRadioButton4 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"myRbListChildrenRenderer");
                        jRadioButton4 = null;
                    }
                    jBTable.setEnabled(jRadioButton4.isSelected());
                    break block11;
                }
                JRadioButton jRadioButton5 = this$0.myRbListChildrenRenderer;
                if (jRadioButton5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"myRbListChildrenRenderer");
                    jRadioButton5 = null;
                }
                if (!Intrinsics.areEqual((Object)object, (Object)jRadioButton5)) break block11;
                JCheckBox jCheckBox = this$0.myAppendDefaultChildrenCheckBox;
                if (jCheckBox == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"myAppendDefaultChildrenCheckBox");
                    jCheckBox = null;
                }
                if ((jRadioButton = this$0.myRbListChildrenRenderer) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"myRbListChildrenRenderer");
                    jRadioButton = null;
                }
                jCheckBox.setEnabled(jRadioButton.isSelected());
                JBTable jBTable = this$0.myChildrenListEditorTable;
                JRadioButton jRadioButton6 = this$0.myRbListChildrenRenderer;
                if (jRadioButton6 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"myRbListChildrenRenderer");
                    jRadioButton6 = null;
                }
                jBTable.setEnabled(jRadioButton6.isSelected());
                PyUserNodeRenderer renderer = this$1.myCurrentRenderer;
                if (this$0.myChildrenListEditorTableModel.getRowCount() == 0 && renderer != null) {
                    PyClass pyClass;
                    PyClass pyClass2 = pyClass = new PyTypeNameResolver(this$1.myProject).resolve(renderer.getToType());
                    if (pyClass2 != null) {
                        pyClass2.visitClassAttributes(arg_0 -> RendererSettings.setupRadioButtons$lambda$0$1(arg_0 -> RendererSettings.setupRadioButtons$lambda$0$0(this$0, arg_0), arg_0), false, null);
                    }
                }
            }
        }

        private static final boolean setupRadioButtons$lambda$0$0(RendererSettings this$0, PyTargetExpression it) {
            this$0.myChildrenListEditorTableModel.addRow("self." + it.getName());
            return true;
        }

        private static final boolean setupRadioButtons$lambda$0$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        public static final /* synthetic */ JTextField access$getMyRendererNameTextField$p(RendererSettings $this) {
            return $this.myRendererNameTextField;
        }

        public static final /* synthetic */ void access$updateSelfType(RendererSettings $this) {
            $this.updateSelfType();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u0005H\u0016J\b\u0010\u000b\u001a\u00020\u0005H\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\u0014\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\u000e\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u0018J\u000e\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\t0 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006#"}, d2={"Lcom/jetbrains/python/debugger/variablesview/usertyperenderers/PyUserTypeRenderersConfigurable$RendererSettings$ChildrenListEditorTableModel;", "Ljavax/swing/table/AbstractTableModel;", "<init>", "(Lcom/jetbrains/python/debugger/variablesview/usertyperenderers/PyUserTypeRenderersConfigurable$RendererSettings;)V", "COLUMN_COUNT", "", "EXPRESSION_TABLE_COLUMN", "myData", "", "Lcom/jetbrains/python/debugger/variablesview/usertyperenderers/PyUserNodeRenderer$ChildInfo;", "getColumnCount", "getRowCount", "isCellEditable", "", "rowIndex", "columnIndex", "getColumnClass", "Ljava/lang/Class;", "getValueAt", "", "setValueAt", "", "aValue", "getColumnName", "", "addRow", "expression", "removeRows", "rows", "", "clear", "clonedChildren", "", "getClonedChildren", "()Ljava/util/List;", "intellij.python.community.impl"})
        @SourceDebugExtension(value={"SMAP\nPyUserTypeRenderersConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyUserTypeRenderersConfigurable.kt\ncom/jetbrains/python/debugger/variablesview/usertyperenderers/PyUserTypeRenderersConfigurable$RendererSettings$ChildrenListEditorTableModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,661:1\n785#2:662\n796#2:663\n1878#2,2:664\n797#2,2:666\n1880#2:668\n799#2:669\n*S KotlinDebug\n*F\n+ 1 PyUserTypeRenderersConfigurable.kt\ncom/jetbrains/python/debugger/variablesview/usertyperenderers/PyUserTypeRenderersConfigurable$RendererSettings$ChildrenListEditorTableModel\n*L\n646#1:662\n646#1:663\n646#1:664,2\n646#1:666,2\n646#1:668\n646#1:669\n*E\n"})
        private final class ChildrenListEditorTableModel
        extends AbstractTableModel {
            private final int COLUMN_COUNT;
            private final int EXPRESSION_TABLE_COLUMN;
            @NotNull
            private final List<PyUserNodeRenderer.ChildInfo> myData = new ArrayList();

            public ChildrenListEditorTableModel() {
                this.COLUMN_COUNT = 1;
            }

            @Override
            public int getColumnCount() {
                return this.COLUMN_COUNT;
            }

            @Override
            public int getRowCount() {
                return this.myData.size();
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return true;
            }

            @Override
            @NotNull
            public Class<?> getColumnClass(int columnIndex) {
                Class clazz;
                if (columnIndex == this.EXPRESSION_TABLE_COLUMN) {
                    clazz = String.class;
                } else {
                    Class<?> clazz2 = super.getColumnClass(columnIndex);
                    clazz = clazz2;
                    Intrinsics.checkNotNullExpressionValue(clazz2, (String)"getColumnClass(...)");
                }
                return clazz;
            }

            @Override
            @Nullable
            public Object getValueAt(int rowIndex, int columnIndex) {
                if (rowIndex >= this.getRowCount()) {
                    return null;
                }
                PyUserNodeRenderer.ChildInfo row = this.myData.get(rowIndex);
                return columnIndex == this.EXPRESSION_TABLE_COLUMN ? row.getExpression() : null;
            }

            @Override
            public void setValueAt(@NotNull Object aValue, int rowIndex, int columnIndex) {
                Intrinsics.checkNotNullParameter((Object)aValue, (String)"aValue");
                if (rowIndex >= this.getRowCount()) {
                    return;
                }
                PyUserNodeRenderer.ChildInfo row = this.myData.get(rowIndex);
                if (columnIndex == this.EXPRESSION_TABLE_COLUMN) {
                    row.setExpression((String)aValue);
                }
            }

            @Override
            @Nullable
            public String getColumnName(int columnIndex) {
                return columnIndex == this.EXPRESSION_TABLE_COLUMN ? null : "";
            }

            public final void addRow(@NotNull String expression) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                this.myData.add(new PyUserNodeRenderer.ChildInfo(expression));
                int lastRow = this.myData.size() - 1;
                this.fireTableRowsInserted(lastRow, lastRow);
            }

            /*
             * WARNING - void declaration
             */
            public final void removeRows(@NotNull int[] rows) {
                void $this$filterIndexedTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)rows, (String)"rows");
                Iterable $this$filterIndexed$iv = this.myData;
                boolean $i$f$filterIndexed = false;
                Iterable iterable = $this$filterIndexed$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIndexedTo = false;
                void $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
                boolean $i$f$forEachIndexed = false;
                int index$iv$iv$iv = 0;
                for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
                    void element$iv$iv;
                    int n;
                    if ((n = index$iv$iv$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    Object t = item$iv$iv$iv;
                    int index$iv$iv = n;
                    boolean bl = false;
                    PyUserNodeRenderer.ChildInfo cfr_ignored_0 = (PyUserNodeRenderer.ChildInfo)element$iv$iv;
                    int id = index$iv$iv;
                    boolean bl2 = false;
                    if (!(!ArraysKt.contains((int[])rows, (int)id))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List nonSelected = (List)destination$iv$iv;
                this.myData.clear();
                this.myData.addAll(nonSelected);
                this.fireTableDataChanged();
            }

            public final void clear() {
                this.myData.clear();
                this.fireTableDataChanged();
            }

            @NotNull
            public final List<PyUserNodeRenderer.ChildInfo> getClonedChildren() {
                return CollectionsKt.toList((Iterable)this.myData);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0082\u0004\u0018\u00002\u00020\u0001:\u0003\u0013\u0014\u0015B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n0\u0005R\u00060\u0006R\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\u0004\u001a\n0\u0005R\u00060\u0006R\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/python/debugger/variablesview/usertyperenderers/PyUserTypeRenderersConfigurable$RendererSettings$ChildrenListEditorToolbarDecorator;", "", "table", "Lcom/intellij/ui/table/JBTable;", "tableModel", "Lcom/jetbrains/python/debugger/variablesview/usertyperenderers/PyUserTypeRenderersConfigurable$RendererSettings$ChildrenListEditorTableModel;", "Lcom/jetbrains/python/debugger/variablesview/usertyperenderers/PyUserTypeRenderersConfigurable$RendererSettings;", "Lcom/jetbrains/python/debugger/variablesview/usertyperenderers/PyUserTypeRenderersConfigurable;", "<init>", "(Lcom/jetbrains/python/debugger/variablesview/usertyperenderers/PyUserTypeRenderersConfigurable$RendererSettings;Lcom/intellij/ui/table/JBTable;Lcom/jetbrains/python/debugger/variablesview/usertyperenderers/PyUserTypeRenderersConfigurable$RendererSettings$ChildrenListEditorTableModel;)V", "getTable", "()Lcom/intellij/ui/table/JBTable;", "getTableModel", "()Lcom/jetbrains/python/debugger/variablesview/usertyperenderers/PyUserTypeRenderersConfigurable$RendererSettings$ChildrenListEditorTableModel;", "decorator", "Lcom/intellij/ui/ToolbarDecorator;", "Lorg/jetbrains/annotations/NotNull;", "getDecorator", "()Lcom/intellij/ui/ToolbarDecorator;", "AddAction", "RemoveAction", "MoveAction", "intellij.python.community.impl"})
        private final class ChildrenListEditorToolbarDecorator {
            @NotNull
            private final JBTable table;
            @NotNull
            private final ChildrenListEditorTableModel tableModel;
            @NotNull
            private final ToolbarDecorator decorator;

            public ChildrenListEditorToolbarDecorator(@NotNull JBTable table, ChildrenListEditorTableModel tableModel) {
                Intrinsics.checkNotNullParameter((Object)table, (String)"table");
                Intrinsics.checkNotNullParameter((Object)tableModel, (String)"tableModel");
                this.table = table;
                this.tableModel = tableModel;
                ToolbarDecorator toolbarDecorator = ToolbarDecorator.createDecorator((JTable)((JTable)this.table));
                Intrinsics.checkNotNullExpressionValue((Object)toolbarDecorator, (String)"createDecorator(...)");
                this.decorator = toolbarDecorator;
                this.decorator.setToolbarPosition(ActionToolbarPosition.TOP);
                this.decorator.setAddAction((AnActionButtonRunnable)new AddAction());
                this.decorator.setRemoveAction((AnActionButtonRunnable)new RemoveAction());
                this.decorator.setMoveUpAction((AnActionButtonRunnable)new MoveAction(true));
                this.decorator.setMoveDownAction((AnActionButtonRunnable)new MoveAction(false));
            }

            @NotNull
            public final JBTable getTable() {
                return this.table;
            }

            @NotNull
            public final ChildrenListEditorTableModel getTableModel() {
                return this.tableModel;
            }

            @NotNull
            public final ToolbarDecorator getDecorator() {
                return this.decorator;
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/jetbrains/python/debugger/variablesview/usertyperenderers/PyUserTypeRenderersConfigurable$RendererSettings$ChildrenListEditorToolbarDecorator$AddAction;", "Lcom/intellij/ui/AnActionButtonRunnable;", "<init>", "(Lcom/jetbrains/python/debugger/variablesview/usertyperenderers/PyUserTypeRenderersConfigurable$RendererSettings$ChildrenListEditorToolbarDecorator;)V", "run", "", "button", "Lcom/intellij/ui/AnActionButton;", "intellij.python.community.impl"})
            private final class AddAction
            implements AnActionButtonRunnable {
                public void run(@Nullable AnActionButton button) {
                    ChildrenListEditorToolbarDecorator.this.getTableModel().addRow("");
                }
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/jetbrains/python/debugger/variablesview/usertyperenderers/PyUserTypeRenderersConfigurable$RendererSettings$ChildrenListEditorToolbarDecorator$MoveAction;", "Lcom/intellij/ui/AnActionButtonRunnable;", "up", "", "<init>", "(Lcom/jetbrains/python/debugger/variablesview/usertyperenderers/PyUserTypeRenderersConfigurable$RendererSettings$ChildrenListEditorToolbarDecorator;Z)V", "getUp", "()Z", "run", "", "button", "Lcom/intellij/ui/AnActionButton;", "intellij.python.community.impl"})
            private final class MoveAction
            implements AnActionButtonRunnable {
                private final boolean up;

                public MoveAction(boolean up) {
                    this.up = up;
                }

                public final boolean getUp() {
                    return this.up;
                }

                public void run(@Nullable AnActionButton button) {
                    int n = this.up ? TableUtil.moveSelectedItemsUp((JTable)((JTable)ChildrenListEditorToolbarDecorator.this.getTable())) : TableUtil.moveSelectedItemsDown((JTable)((JTable)ChildrenListEditorToolbarDecorator.this.getTable()));
                }
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/jetbrains/python/debugger/variablesview/usertyperenderers/PyUserTypeRenderersConfigurable$RendererSettings$ChildrenListEditorToolbarDecorator$RemoveAction;", "Lcom/intellij/ui/AnActionButtonRunnable;", "<init>", "(Lcom/jetbrains/python/debugger/variablesview/usertyperenderers/PyUserTypeRenderersConfigurable$RendererSettings$ChildrenListEditorToolbarDecorator;)V", "run", "", "button", "Lcom/intellij/ui/AnActionButton;", "intellij.python.community.impl"})
            private final class RemoveAction
            implements AnActionButtonRunnable {
                public void run(@Nullable AnActionButton button) {
                    ChildrenListEditorTableModel childrenListEditorTableModel = ChildrenListEditorToolbarDecorator.this.getTableModel();
                    int[] nArray = ChildrenListEditorToolbarDecorator.this.getTable().getSelectedRows();
                    Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getSelectedRows(...)");
                    childrenListEditorTableModel.removeRows(nArray);
                }
            }
        }
    }
}

