/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.glossaries;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.GenericCommand;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.TextualContentCommand;
import com.dickimawbooks.texparserlib.UserNumber;
import com.dickimawbooks.texparserlib.latex.glossaries.AbstractGlsCommand;
import com.dickimawbooks.texparserlib.latex.glossaries.GlossariesSty;
import com.dickimawbooks.texparserlib.latex.glossaries.GlsLabel;
import com.dickimawbooks.texparserlib.primitives.RomanNumeral;
import java.io.IOException;

public class AtGlsXtrAtCheckGroup
extends AbstractGlsCommand {
    public AtGlsXtrAtCheckGroup(GlossariesSty glossariesSty) {
        this("@glsxtr@checkgroup", glossariesSty);
    }

    public AtGlsXtrAtCheckGroup(String string, GlossariesSty glossariesSty) {
        super(string, glossariesSty);
    }

    @Override
    public Object clone() {
        return new AtGlsXtrAtCheckGroup(this.getName(), this.getSty());
    }

    @Override
    public boolean canExpand() {
        return false;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return null;
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        Object object;
        Object object2;
        GlsLabel glsLabel = this.popEntryLabel(teXParser, teXObjectList);
        TeXObject teXObject = null;
        String string = "";
        if (this.sty.isKnownField("group")) {
            object2 = teXParser.expandToString(teXParser.getControlSequence("glsxtrgroupfield"), teXObjectList).trim();
            object = glsLabel.getEntry().get((String)object2);
            if (object != null && !object.isEmpty()) {
                string = teXParser.expandToString((TeXObject)object, teXObjectList);
                teXObject = teXParser.getListener().createGroup(string);
            }
        } else {
            object2 = glsLabel.getEntry().get("sort");
            if (object2 != null && !object2.isEmpty() && !(string = teXParser.expandToString((TeXObject)object2, teXObjectList)).isEmpty()) {
                int n = string.codePointAt(0);
                teXObject = new UserNumber(n);
                string = "" + n;
            }
        }
        if (teXObject != null) {
            ControlSequence controlSequence;
            int n = TeXParserUtils.toInt(teXParser.getControlSequence("glscurrententrylevel"), teXParser, teXObjectList);
            object = "@gls@currentlettergroup";
            if (n > 0) {
                object = (String)object + RomanNumeral.romannumeral(n);
            }
            if ((controlSequence = teXParser.getControlSequence((String)object)) == null) {
                teXParser.putControlSequence(true, new TextualContentCommand((String)object, ""));
            } else {
                TeXObjectList teXObjectList2 = teXParser.getListener().createStack();
                teXParser.putControlSequence(true, new GenericCommand(true, "@glsxtr@groupheading", null, teXObjectList2));
                String string2 = teXParser.expandToString(controlSequence, teXObjectList);
                if (!string2.equals(string)) {
                    if (n > 0) {
                        teXObjectList2.add(new TeXCsRef("glssubgroupheading"));
                        teXObjectList2.add(new UserNumber(TeXParserUtils.toInt(teXParser.getControlSequence("@gls@currentlettergroup@level"), teXParser, teXObjectList)));
                        teXObjectList2.add(new UserNumber(n));
                        teXObjectList2.add(teXObject);
                    } else {
                        if (!string2.isEmpty()) {
                            teXObjectList2.add(new TeXCsRef("glsgroupskip"));
                        }
                        teXObjectList2.add(new TeXCsRef("glsgroupheading"));
                        teXObjectList2.add(teXObject);
                    }
                    teXParser.putControlSequence(true, new GenericCommand(true, "@gls@currentlettergroup@level", null, new UserNumber(n)));
                    teXParser.putControlSequence(true, new TextualContentCommand((String)object, string));
                }
            }
        } else {
            teXParser.putControlSequence(true, new TextualContentCommand("@glsxtr@groupheading", ""));
        }
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }
}

