﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/invoicing/Invoicing_EXPORTS.h>
#include <aws/invoicing/model/InvoiceProfile.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Invoicing {
namespace Model {
class BatchGetInvoiceProfileResult {
 public:
  AWS_INVOICING_API BatchGetInvoiceProfileResult() = default;
  AWS_INVOICING_API BatchGetInvoiceProfileResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_INVOICING_API BatchGetInvoiceProfileResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p> A list of invoice profiles corresponding to the requested accounts. </p>
   */
  inline const Aws::Vector<InvoiceProfile>& GetProfiles() const { return m_profiles; }
  template <typename ProfilesT = Aws::Vector<InvoiceProfile>>
  void SetProfiles(ProfilesT&& value) {
    m_profilesHasBeenSet = true;
    m_profiles = std::forward<ProfilesT>(value);
  }
  template <typename ProfilesT = Aws::Vector<InvoiceProfile>>
  BatchGetInvoiceProfileResult& WithProfiles(ProfilesT&& value) {
    SetProfiles(std::forward<ProfilesT>(value));
    return *this;
  }
  template <typename ProfilesT = InvoiceProfile>
  BatchGetInvoiceProfileResult& AddProfiles(ProfilesT&& value) {
    m_profilesHasBeenSet = true;
    m_profiles.emplace_back(std::forward<ProfilesT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  BatchGetInvoiceProfileResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<InvoiceProfile> m_profiles;

  Aws::String m_requestId;
  bool m_profilesHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Invoicing
}  // namespace Aws
