﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/docdb/DocDB_EXPORTS.h>
#include <aws/docdb/model/ResourcePendingMaintenanceActions.h>
#include <aws/docdb/model/ResponseMetadata.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Xml {
class XmlDocument;
}  // namespace Xml
}  // namespace Utils
namespace DocDB {
namespace Model {
class ApplyPendingMaintenanceActionResult {
 public:
  AWS_DOCDB_API ApplyPendingMaintenanceActionResult() = default;
  AWS_DOCDB_API ApplyPendingMaintenanceActionResult(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
  AWS_DOCDB_API ApplyPendingMaintenanceActionResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);

  ///@{

  inline const ResourcePendingMaintenanceActions& GetResourcePendingMaintenanceActions() const {
    return m_resourcePendingMaintenanceActions;
  }
  template <typename ResourcePendingMaintenanceActionsT = ResourcePendingMaintenanceActions>
  void SetResourcePendingMaintenanceActions(ResourcePendingMaintenanceActionsT&& value) {
    m_resourcePendingMaintenanceActionsHasBeenSet = true;
    m_resourcePendingMaintenanceActions = std::forward<ResourcePendingMaintenanceActionsT>(value);
  }
  template <typename ResourcePendingMaintenanceActionsT = ResourcePendingMaintenanceActions>
  ApplyPendingMaintenanceActionResult& WithResourcePendingMaintenanceActions(ResourcePendingMaintenanceActionsT&& value) {
    SetResourcePendingMaintenanceActions(std::forward<ResourcePendingMaintenanceActionsT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const ResponseMetadata& GetResponseMetadata() const { return m_responseMetadata; }
  template <typename ResponseMetadataT = ResponseMetadata>
  void SetResponseMetadata(ResponseMetadataT&& value) {
    m_responseMetadataHasBeenSet = true;
    m_responseMetadata = std::forward<ResponseMetadataT>(value);
  }
  template <typename ResponseMetadataT = ResponseMetadata>
  ApplyPendingMaintenanceActionResult& WithResponseMetadata(ResponseMetadataT&& value) {
    SetResponseMetadata(std::forward<ResponseMetadataT>(value));
    return *this;
  }
  ///@}
 private:
  ResourcePendingMaintenanceActions m_resourcePendingMaintenanceActions;

  ResponseMetadata m_responseMetadata;
  bool m_resourcePendingMaintenanceActionsHasBeenSet = false;
  bool m_responseMetadataHasBeenSet = false;
};

}  // namespace Model
}  // namespace DocDB
}  // namespace Aws
