// Copyright (c) 2020 GeometryFactory SARL (France).
// All rights reserved.
//
// This file is part of CGAL (www.cgal.org).
//
// $URL: https://github.com/CGAL/cgal/blob/v6.1.1/Shape_regularization/include/CGAL/Shape_regularization.h $
// $Id: include/CGAL/Shape_regularization.h 08b27d3db14 $
// SPDX-License-Identifier: GPL-3.0-or-later OR LicenseRef-Commercial
//
//
// Author(s)     : Dmitry Anisimov, Gennadii Sytov, Simon Giraudot, Jean-Philippe Bauchet, Florent Lafarge
//

#ifndef CGAL_SHAPE_REGULARIZATION_HEADERS_H
#define CGAL_SHAPE_REGULARIZATION_HEADERS_H

/// \cond SKIP_IN_MANUAL
#include <CGAL/license/Shape_regularization.h>
/// \endcond

/**
* \ingroup PkgShapeRegularizationRef
* \file CGAL/Shape_regularization.h
* A convenience header that includes all free functions and classes for shape regularization.
*/

#include <CGAL/Shape_regularization/regularize_planes.h>
#include <CGAL/Shape_regularization/regularize_segments.h>
#include <CGAL/Shape_regularization/regularize_contours.h>
#include <CGAL/Shape_regularization/QP_regularization.h>

#endif // CGAL_SHAPE_REGULARIZATION_HEADERS_H
