/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.index.DocFieldConsumer;
import org.apache.lucene.index.DocFieldConsumerPerField;
import org.apache.lucene.index.DocFieldConsumerPerThread;
import org.apache.lucene.index.DocFieldConsumersPerField;
import org.apache.lucene.index.DocFieldConsumersPerThread;
import org.apache.lucene.index.DocFieldProcessorPerThread;
import org.apache.lucene.index.DocumentsWriter;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.util.ArrayUtil;

final class DocFieldConsumers
extends DocFieldConsumer {
    final DocFieldConsumer one;
    final DocFieldConsumer two;
    PerDoc[] docFreeList = new PerDoc[1];
    int freeCount;
    int allocCount;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DocFieldConsumers(DocFieldConsumer one, DocFieldConsumer two) {
        this.one = one;
        this.two = two;
    }

    void setFieldInfos(FieldInfos fieldInfos) {
        super.setFieldInfos(fieldInfos);
        this.one.setFieldInfos(fieldInfos);
        this.two.setFieldInfos(fieldInfos);
    }

    public void flush(Map threadsAndFields, DocumentsWriter.FlushState state) throws IOException {
        HashMap oneThreadsAndFields = new HashMap();
        HashMap twoThreadsAndFields = new HashMap();
        Iterator it = threadsAndFields.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            DocFieldConsumersPerThread perThread = (DocFieldConsumersPerThread)entry.getKey();
            Collection fields = (Collection)entry.getValue();
            Iterator fieldsIt = fields.iterator();
            HashSet<DocFieldConsumerPerField> oneFields = new HashSet<DocFieldConsumerPerField>();
            HashSet<DocFieldConsumerPerField> twoFields = new HashSet<DocFieldConsumerPerField>();
            while (fieldsIt.hasNext()) {
                DocFieldConsumersPerField perField = (DocFieldConsumersPerField)fieldsIt.next();
                oneFields.add(perField.one);
                twoFields.add(perField.two);
            }
            oneThreadsAndFields.put(perThread.one, oneFields);
            twoThreadsAndFields.put(perThread.two, twoFields);
        }
        this.one.flush(oneThreadsAndFields, state);
        this.two.flush(twoThreadsAndFields, state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeDocStore(DocumentsWriter.FlushState state) throws IOException {
        try {
            this.one.closeDocStore(state);
        }
        finally {
            this.two.closeDocStore(state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        try {
            this.one.abort();
        }
        finally {
            this.two.abort();
        }
    }

    public boolean freeRAM() {
        boolean any = this.one.freeRAM();
        return any |= this.two.freeRAM();
    }

    public DocFieldConsumerPerThread addThread(DocFieldProcessorPerThread docFieldProcessorPerThread) throws IOException {
        return new DocFieldConsumersPerThread(docFieldProcessorPerThread, this, this.one.addThread(docFieldProcessorPerThread), this.two.addThread(docFieldProcessorPerThread));
    }

    synchronized PerDoc getPerDoc() {
        if (this.freeCount == 0) {
            ++this.allocCount;
            if (this.allocCount > this.docFreeList.length) {
                if (!$assertionsDisabled && this.allocCount != 1 + this.docFreeList.length) {
                    throw new AssertionError();
                }
                this.docFreeList = new PerDoc[ArrayUtil.getNextSize(this.allocCount)];
            }
            return new PerDoc();
        }
        return this.docFreeList[--this.freeCount];
    }

    synchronized void freePerDoc(PerDoc perDoc) {
        if (!$assertionsDisabled && this.freeCount >= this.docFreeList.length) {
            throw new AssertionError();
        }
        this.docFreeList[this.freeCount++] = perDoc;
    }

    static {
        $assertionsDisabled = !DocFieldConsumers.class.desiredAssertionStatus();
    }

    class PerDoc
    extends DocumentsWriter.DocWriter {
        DocumentsWriter.DocWriter one;
        DocumentsWriter.DocWriter two;

        PerDoc() {
        }

        public long sizeInBytes() {
            return this.one.sizeInBytes() + this.two.sizeInBytes();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finish() throws IOException {
            try {
                try {
                    this.one.finish();
                }
                finally {
                    this.two.finish();
                }
            }
            finally {
                DocFieldConsumers.this.freePerDoc(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void abort() {
            try {
                try {
                    this.one.abort();
                }
                finally {
                    this.two.abort();
                }
            }
            finally {
                DocFieldConsumers.this.freePerDoc(this);
            }
        }
    }
}

