/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.inspections.shared.collections;

import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.collections.AbstractUselessCallInspection;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\u0003H\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J$\u0010\u0011\u001a\u00020\n*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\f\u0010\u0004\u001a\u00020\n*\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/collections/RenameUselessCallFix;", "Lcom/intellij/modcommand/PsiUpdateModCommandQuickFix;", "newName", "", "invert", "", "<init>", "(Ljava/lang/String;Z)V", "getFamilyName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "element", "Lcom/intellij/psi/PsiElement;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "renameGivenReturnLabels", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "factory", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "labelName", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "kotlin.code-insight.inspections.shared"})
@SourceDebugExtension(value={"SMAP\nRenameUselessCallFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RenameUselessCallFix.kt\norg/jetbrains/kotlin/idea/codeInsight/inspections/shared/collections/RenameUselessCallFix\n+ 2 KotlinPsiModificationUtils.kt\norg/jetbrains/kotlin/idea/base/psi/KotlinPsiModificationUtils\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,56:1\n29#2,7:57\n125#3:64\n*S KotlinDebug\n*F\n+ 1 RenameUselessCallFix.kt\norg/jetbrains/kotlin/idea/codeInsight/inspections/shared/collections/RenameUselessCallFix\n*L\n22#1:57,7\n51#1:64\n*E\n"})
public final class RenameUselessCallFix
extends PsiUpdateModCommandQuickFix {
    @NotNull
    private final String newName;
    private final boolean invert;

    public RenameUselessCallFix(@NotNull String newName, boolean invert) {
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        this.newName = newName;
        this.invert = invert;
    }

    public /* synthetic */ RenameUselessCallFix(String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(string, bl);
    }

    @NotNull
    public String getFamilyName() {
        Object[] objectArray = new Object[]{this.newName};
        return KotlinBundle.message((String)"rename.redundant.call.fix.text", (Object[])objectArray);
    }

    /*
     * WARNING - void declaration
     */
    protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater2) {
        PsiElement result$iv;
        void $this$replaced$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
        KtQualifiedExpression ktQualifiedExpression = element instanceof KtQualifiedExpression ? (KtQualifiedExpression)element : null;
        if (ktQualifiedExpression == null) {
            return;
        }
        KtQualifiedExpression qualifiedExpression = ktQualifiedExpression;
        KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
        KtExpression ktExpression = qualifiedExpression.getSelectorExpression();
        KtCallExpression selectorCallExpression = ktExpression instanceof KtCallExpression ? (KtCallExpression)ktExpression : null;
        KtCallExpression ktCallExpression = selectorCallExpression;
        if (ktCallExpression == null || (ktCallExpression = ktCallExpression.getCalleeExpression()) == null) {
            return;
        }
        KtCallExpression calleeExpression = ktCallExpression;
        PsiElement psiElement = (PsiElement)calleeExpression;
        PsiElement newElement$iv = (PsiElement)psiFactory.createExpression(this.newName);
        boolean $i$f$replaced = false;
        if (!Intrinsics.areEqual((Object)$this$replaced$iv, (Object)newElement$iv) && !((result$iv = $this$replaced$iv.replace(newElement$iv)) instanceof KtExpression)) {
            Intrinsics.checkNotNull((Object)result$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
            KtExpression ktExpression2 = ((KtParenthesizedExpression)result$iv).getExpression();
            if (ktExpression2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
            PsiElement cfr_ignored_0 = (PsiElement)ktExpression2;
        }
        String string = calleeExpression.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        this.renameGivenReturnLabels(selectorCallExpression, psiFactory, string, this.newName);
        if (this.invert) {
            this.invert(qualifiedExpression);
        }
    }

    private final void renameGivenReturnLabels(KtCallExpression $this$renameGivenReturnLabels, KtPsiFactory factory2, String labelName, String newName) {
        KtLambdaArgument ktLambdaArgument = (KtLambdaArgument)CollectionsKt.firstOrNull((List)$this$renameGivenReturnLabels.getLambdaArguments());
        if (ktLambdaArgument == null || (ktLambdaArgument = ktLambdaArgument.getLambdaExpression()) == null) {
            return;
        }
        KtLambdaArgument lambdaExpression = ktLambdaArgument;
        KtBlockExpression ktBlockExpression = lambdaExpression.getBodyExpression();
        if (ktBlockExpression == null) {
            return;
        }
        KtBlockExpression bodyExpression = ktBlockExpression;
        String expectedLabelText = "@" + labelName;
        Map replacementMap = new LinkedHashMap();
        bodyExpression.accept((PsiElementVisitor)new AbstractUselessCallInspection.ScopedLabelVisitor(labelName, expectedLabelText, factory2, newName, replacementMap){
            final /* synthetic */ String $expectedLabelText;
            final /* synthetic */ KtPsiFactory $factory;
            final /* synthetic */ String $newName;
            final /* synthetic */ Map<PsiElement, PsiElement> $replacementMap;
            {
                this.$expectedLabelText = $expectedLabelText;
                this.$factory = $factory;
                this.$newName = $newName;
                this.$replacementMap = $replacementMap;
                super($labelName);
            }

            public Void visitReturnExpression(KtReturnExpression expression, Unit data) {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                    Object object = expression.getLabeledExpression();
                    if (object == null) break block2;
                    PsiElement psiElement = object;
                    String string = this.$expectedLabelText;
                    PsiElement it = psiElement;
                    boolean bl = false;
                    object = Intrinsics.areEqual((Object)it.getText(), (Object)string) ? psiElement : null;
                    if (object != null) {
                        KtContainerNode newReturn;
                        psiElement = object;
                        string = this.$factory;
                        String string2 = this.$newName;
                        Map<PsiElement, PsiElement> map2 = this.$replacementMap;
                        PsiElement labeledExpression = psiElement;
                        boolean bl2 = false;
                        Object[] objectArray = new Object[]{string2};
                        PsiElement[] psiElementArray = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)string, (String)"return@$0", (Object[])objectArray, (boolean)false, (int)4, null).getChildren();
                        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
                        Object object2 = ArraysKt.firstOrNull((Object[])psiElementArray);
                        KtContainerNode ktContainerNode = newReturn = object2 instanceof KtContainerNode ? (KtContainerNode)object2 : null;
                        if (newReturn != null) {
                            map2.put(labeledExpression, (PsiElement)newReturn);
                        }
                    }
                }
                return (Void)super.visitReturnExpression(expression, (Object)data);
            }
        });
        replacementMap.forEach((arg_0, arg_1) -> RenameUselessCallFix.renameGivenReturnLabels$lambda$1(RenameUselessCallFix::renameGivenReturnLabels$lambda$0, arg_0, arg_1));
    }

    private final void invert(KtQualifiedExpression $this$invert) {
        PsiElement $this$safeAs$iv = $this$invert.getParent();
        boolean $i$f$safeAs = false;
        PsiElement psiElement = $this$safeAs$iv;
        if (!(psiElement instanceof KtPrefixExpression)) {
            psiElement = null;
        }
        KtPrefixExpression ktPrefixExpression = (KtPrefixExpression)psiElement;
        if (ktPrefixExpression == null) {
            return;
        }
        KtPrefixExpression parent = ktPrefixExpression;
        KtExpression ktExpression = parent.getBaseExpression();
        if (ktExpression == null) {
            return;
        }
        KtExpression baseExpression = ktExpression;
        parent.replace((PsiElement)baseExpression);
    }

    private static final Unit renameGivenReturnLabels$lambda$0(PsiElement original, PsiElement replacement) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
        original.replace(replacement);
        return Unit.INSTANCE;
    }

    private static final void renameGivenReturnLabels$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }
}

