/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script.k2.navigation;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.UseScopeEnlarger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/k2/navigation/KotlinScriptUseScopeEnlarger;", "Lcom/intellij/psi/search/UseScopeEnlarger;", "<init>", "()V", "getAdditionalUseScope", "Lcom/intellij/psi/search/SearchScope;", "element", "Lcom/intellij/psi/PsiElement;", "ProjectFileByExtensionSearchScope", "intellij.kotlin.base.scripting"})
public final class KotlinScriptUseScopeEnlarger
extends UseScopeEnlarger {
    @Nullable
    public SearchScope getAdditionalUseScope(@NotNull PsiElement element) {
        SearchScope searchScope;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiFile psiFile = element.getContainingFile();
        KtFile ktFile2 = psiFile instanceof KtFile ? (KtFile)psiFile : null;
        if (ktFile2 == null) {
            return null;
        }
        KtFile file = ktFile2;
        boolean isInjection = file.getVirtualFile() instanceof VirtualFileWindow;
        if (file.isScript() && !isInjection) {
            Project project = element.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            searchScope = (SearchScope)new ProjectFileByExtensionSearchScope(project, "kts");
        } else {
            searchScope = null;
        }
        return searchScope;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0011\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0096\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/k2/navigation/KotlinScriptUseScopeEnlarger$ProjectFileByExtensionSearchScope;", "Lcom/intellij/psi/search/DelegatingGlobalSearchScope;", "project", "Lcom/intellij/openapi/project/Project;", "extension", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "contains", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.kotlin.base.scripting"})
    private static final class ProjectFileByExtensionSearchScope
    extends DelegatingGlobalSearchScope {
        @NotNull
        private final String extension;

        public ProjectFileByExtensionSearchScope(@NotNull Project project, @NotNull String extension) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
            super(DelegatingGlobalSearchScope.projectScope((Project)project));
            this.extension = extension;
        }

        public boolean contains(@NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return super.contains(file) && Intrinsics.areEqual((Object)file.getExtension(), (Object)this.extension);
        }
    }
}

