/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.stepping.filter;

import com.sun.jdi.Location;
import com.sun.jdi.Method;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J+\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/stepping/filter/StepOverCallerInfo;", "", "declaringType", "", "methodName", "methodSignature", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getDeclaringType", "()Ljava/lang/String;", "getMethodName", "getMethodSignature", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "intellij.kotlin.jvm.debugger.core"})
public final class StepOverCallerInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String declaringType;
    @Nullable
    private final String methodName;
    @Nullable
    private final String methodSignature;

    public StepOverCallerInfo(@NotNull String declaringType, @Nullable String methodName, @Nullable String methodSignature) {
        Intrinsics.checkNotNullParameter((Object)declaringType, (String)"declaringType");
        this.declaringType = declaringType;
        this.methodName = methodName;
        this.methodSignature = methodSignature;
    }

    @NotNull
    public final String getDeclaringType() {
        return this.declaringType;
    }

    @Nullable
    public final String getMethodName() {
        return this.methodName;
    }

    @Nullable
    public final String getMethodSignature() {
        return this.methodSignature;
    }

    @NotNull
    public final String component1() {
        return this.declaringType;
    }

    @Nullable
    public final String component2() {
        return this.methodName;
    }

    @Nullable
    public final String component3() {
        return this.methodSignature;
    }

    @NotNull
    public final StepOverCallerInfo copy(@NotNull String declaringType, @Nullable String methodName, @Nullable String methodSignature) {
        Intrinsics.checkNotNullParameter((Object)declaringType, (String)"declaringType");
        return new StepOverCallerInfo(declaringType, methodName, methodSignature);
    }

    public static /* synthetic */ StepOverCallerInfo copy$default(StepOverCallerInfo stepOverCallerInfo, String string, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string = stepOverCallerInfo.declaringType;
        }
        if ((n & 2) != 0) {
            string2 = stepOverCallerInfo.methodName;
        }
        if ((n & 4) != 0) {
            string3 = stepOverCallerInfo.methodSignature;
        }
        return stepOverCallerInfo.copy(string, string2, string3);
    }

    @NotNull
    public String toString() {
        return "StepOverCallerInfo(declaringType=" + this.declaringType + ", methodName=" + this.methodName + ", methodSignature=" + this.methodSignature + ")";
    }

    public int hashCode() {
        int result2 = this.declaringType.hashCode();
        result2 = result2 * 31 + (this.methodName == null ? 0 : this.methodName.hashCode());
        result2 = result2 * 31 + (this.methodSignature == null ? 0 : this.methodSignature.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StepOverCallerInfo)) {
            return false;
        }
        StepOverCallerInfo stepOverCallerInfo = (StepOverCallerInfo)other;
        if (!Intrinsics.areEqual((Object)this.declaringType, (Object)stepOverCallerInfo.declaringType)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.methodName, (Object)stepOverCallerInfo.methodName)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.methodSignature, (Object)stepOverCallerInfo.methodSignature);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/stepping/filter/StepOverCallerInfo$Companion;", "", "<init>", "()V", "from", "Lorg/jetbrains/kotlin/idea/debugger/core/stepping/filter/StepOverCallerInfo;", "location", "Lcom/sun/jdi/Location;", "intellij.kotlin.jvm.debugger.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final StepOverCallerInfo from(@NotNull Location location) {
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            Method method = SafeUtilKt.safeMethod(location);
            String declaringType = location.declaringType().name();
            Method method2 = method;
            String methodName = method2 != null ? method2.name() : null;
            Method method3 = method;
            String methodSignature = method3 != null ? method3.signature() : null;
            Intrinsics.checkNotNull((Object)declaringType);
            return new StepOverCallerInfo(declaringType, methodName, methodSignature);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

