/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.google.common.collect.ImmutableSet;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Query;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.codeinsight.utils.KotlinPsiUtilsKt;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.idea.refactoring.CallableRefactoring;
import org.jetbrains.kotlin.idea.refactoring.CallableRefactoringKt;
import org.jetbrains.kotlin.idea.refactoring.KotlinCommonRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.references.KtSimpleNameReference;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.load.java.PropertiesConventionUtilKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeConstraint;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u00022\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertFunctionToPropertyIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "<init>", "()V", "startInWriteAction", "", "isApplicableTo", "element", "caretOffset", "", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "Converter", "kotlin.idea"})
public final class ConvertFunctionToPropertyIntention
extends SelfTargetingIntention<KtNamedFunction>
implements LowPriorityAction {
    public ConvertFunctionToPropertyIntention() {
        super(KtNamedFunction.class, KotlinBundle.messagePointer((String)"convert.function.to.property", (Object[])new Object[0]), null, 4, null);
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    public boolean isApplicableTo(@NotNull KtNamedFunction element, int caretOffset) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement = element.getFunKeyword();
        if (psiElement == null) {
            return false;
        }
        PsiElement funKeyword = psiElement;
        PsiElement psiElement2 = element.getNameIdentifier();
        if (psiElement2 == null) {
            return false;
        }
        PsiElement identifier = psiElement2;
        if (!new TextRange(PsiUtilsKt.getStartOffset((PsiElement)funKeyword), PsiUtilsKt.getEndOffset((PsiElement)identifier)).containsOffset(caretOffset)) {
            return false;
        }
        KtClass ktClass = KtPsiUtilKt.containingClass((KtElement)((KtElement)element));
        boolean bl = ktClass != null ? KotlinPsiUtilsKt.isFunInterface(ktClass) : false;
        if (bl && !element.hasBody()) {
            return false;
        }
        if (!((Collection)element.getValueParameters()).isEmpty() || element.isLocal()) {
            return false;
        }
        String string = element.getName();
        Intrinsics.checkNotNull((Object)string);
        String name2 = string;
        if (Intrinsics.areEqual((Object)name2, (Object)"invoke") || Intrinsics.areEqual((Object)name2, (Object)"iterator") || ((ImmutableSet)OperatorConventions.UNARY_OPERATION_NAMES.inverse().keySet()).contains((Object)Name.identifier((String)name2))) {
            return false;
        }
        FunctionDescriptor functionDescriptor = ResolutionUtils.resolveToDescriptorIfAny$default(element, null, 1, null);
        if (functionDescriptor == null) {
            return false;
        }
        FunctionDescriptor descriptor2 = functionDescriptor;
        KotlinType kotlinType = descriptor2.getReturnType();
        if (kotlinType == null) {
            return false;
        }
        KotlinType returnType = kotlinType;
        return !KotlinBuiltIns.isUnit((KotlinType)returnType) && !KotlinBuiltIns.isNothing((KotlinType)returnType);
    }

    @Override
    public void applyTo(@NotNull KtNamedFunction element, @Nullable Editor editor) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        DeclarationDescriptor declarationDescriptor = ResolutionUtils.unsafeResolveToDescriptor((KtDeclaration)element, BodyResolveMode.PARTIAL);
        Intrinsics.checkNotNull((Object)declarationDescriptor, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.FunctionDescriptor");
        FunctionDescriptor descriptor2 = (FunctionDescriptor)declarationDescriptor;
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtFile ktFile2 = element.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile2, (String)"getContainingKtFile(...)");
        new Converter(project, ktFile2, editor, descriptor2).run();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0016\u0010\u001e\u001a\u00020\u00172\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0014J\u0018\u0010\"\u001a\u0004\u0018\u00010#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020#0 H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00020\u000e`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertFunctionToPropertyIntention$Converter;", "Lorg/jetbrains/kotlin/idea/refactoring/CallableRefactoring;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "descriptor", "<init>", "(Lorg/jetbrains/kotlin/idea/intentions/ConvertFunctionToPropertyIntention;Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/psi/KtFile;Lcom/intellij/openapi/editor/Editor;Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;)V", "elementsToShorten", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/psi/KtElement;", "Lkotlin/collections/ArrayList;", "newName", "", "getNewName", "()Ljava/lang/String;", "newName$delegate", "Lkotlin/Lazy;", "convertFunction", "", "originalFunction", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "psiFactory", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "moveCaret", "", "performRefactoring", "descriptorsForChange", "", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "findMainElement", "Lcom/intellij/psi/PsiElement;", "callables", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nConvertFunctionToPropertyIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConvertFunctionToPropertyIntention.kt\norg/jetbrains/kotlin/idea/intentions/ConvertFunctionToPropertyIntention$Converter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 KotlinPsiModificationUtils.kt\norg/jetbrains/kotlin/idea/base/psi/KotlinPsiModificationUtils\n+ 5 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,198:1\n1563#2:199\n1634#2,3:200\n1563#2:204\n1634#2,3:205\n1869#2,2:219\n1869#2,2:221\n1869#2,2:223\n1869#2,2:225\n1#3:203\n29#4,7:208\n300#5,2:215\n232#5:217\n249#5:218\n*S KotlinDebug\n*F\n+ 1 ConvertFunctionToPropertyIntention.kt\norg/jetbrains/kotlin/idea/intentions/ConvertFunctionToPropertyIntention$Converter\n*L\n62#1:199\n62#1:200,3\n66#1:204\n66#1:205,3\n152#1:219,2\n153#1:221,2\n154#1:223,2\n155#1:225,2\n80#1:208,7\n113#1:215,2\n113#1:217\n114#1:218\n*E\n"})
    private final class Converter
    extends CallableRefactoring<FunctionDescriptor> {
        @NotNull
        private final KtFile file;
        @NotNull
        private final ArrayList<KtElement> elementsToShorten;
        @NotNull
        private final Lazy newName$delegate;

        public Converter(@NotNull Project project, @Nullable KtFile file, @NotNull Editor editor, FunctionDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            super(project, editor, (CallableDescriptor)descriptor2, ConvertFunctionToPropertyIntention.this.getText());
            this.file = file;
            this.elementsToShorten = new ArrayList();
            this.newName$delegate = LazyKt.lazy(() -> Converter.newName_delegate$lambda$0(this));
        }

        private final String getNewName() {
            Lazy lazy = this.newName$delegate;
            return (String)lazy.getValue();
        }

        /*
         * WARNING - void declaration
         */
        private final void convertFunction(KtNamedFunction originalFunction, KtPsiFactory psiFactory, boolean moveCaret) {
            PsiElement psiElement;
            void $this$replaced$iv;
            Object it;
            KtTypeConstraint it2;
            Collection collection;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            KtPsiFactory.CallableBuilder callableBuilder;
            KtPsiFactory.CallableBuilder $this$convertFunction_u24lambda_u240 = callableBuilder = new KtPsiFactory.CallableBuilder(KtPsiFactory.CallableBuilder.Target.READ_ONLY_PROPERTY);
            boolean bl = false;
            String string = originalFunction.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            Object object = string;
            int n = 0;
            PsiElement psiElement2 = originalFunction.getFunKeyword();
            Intrinsics.checkNotNull((Object)psiElement2);
            int n2 = PsiUtilsKt.getStartOffsetIn((PsiElement)psiElement2, (PsiElement)((PsiElement)originalFunction));
            String string2 = ((String)object).substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            $this$convertFunction_u24lambda_u240.modifier(string2);
            List list2 = originalFunction.getTypeParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getTypeParameters(...)");
            object = list2;
            KtPsiFactory.CallableBuilder callableBuilder2 = $this$convertFunction_u24lambda_u240;
            boolean $i$f$map = false;
            void var10_13 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                KtTypeParameter ktTypeParameter = (KtTypeParameter)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it2.getText());
            }
            callableBuilder2.typeParams((Collection)((List)destination$iv$iv));
            KtTypeReference ktTypeReference = originalFunction.getReceiverTypeReference();
            if (ktTypeReference != null) {
                it = ktTypeReference;
                boolean bl3 = false;
                String string3 = it.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
                $this$convertFunction_u24lambda_u240.receiver(string3);
            }
            $this$convertFunction_u24lambda_u240.name(this.getNewName());
            KtTypeReference ktTypeReference2 = KotlinPsiUtils.getReturnTypeReference((KtNamedDeclaration)originalFunction);
            if (ktTypeReference2 != null) {
                it = ktTypeReference2;
                boolean bl4 = false;
                String string4 = it.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getText(...)");
                $this$convertFunction_u24lambda_u240.returnType(string4);
            }
            List list3 = originalFunction.getTypeConstraints();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getTypeConstraints(...)");
            $this$map$iv = list3;
            callableBuilder2 = $this$convertFunction_u24lambda_u240;
            $i$f$map = false;
            it = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it2 = (KtTypeConstraint)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl5 = false;
                collection.add(it2.getText());
            }
            callableBuilder2.typeConstraints((Collection)((List)destination$iv$iv));
            if (originalFunction.getEqualsToken() != null) {
                KtExpression ktExpression = originalFunction.getBodyExpression();
                Intrinsics.checkNotNull((Object)ktExpression);
                String string5 = ktExpression.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getText(...)");
                $this$convertFunction_u24lambda_u240.getterExpression(string5, originalFunction.getTypeReference() != null);
            } else {
                KtBlockExpression ktBlockExpression = originalFunction.getBodyBlockExpression();
                if (ktBlockExpression != null) {
                    KtBlockExpression body2 = ktBlockExpression;
                    boolean bl6 = false;
                    $this$convertFunction_u24lambda_u240.transform(arg_0 -> Converter.convertFunction$lambda$0$4$0(body2, arg_0));
                }
            }
            String propertyString = callableBuilder.asString();
            $this$convertFunction_u24lambda_u240 = (PsiElement)originalFunction;
            PsiElement newElement$iv = (PsiElement)psiFactory.createDeclaration(propertyString);
            boolean $i$f$replaced = false;
            if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)newElement$iv)) {
                psiElement = newElement$iv;
            } else {
                PsiElement result$iv = $this$replaced$iv.replace(newElement$iv);
                if (result$iv instanceof KtProperty) {
                    psiElement = result$iv;
                } else {
                    Intrinsics.checkNotNull((Object)result$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                    KtExpression ktExpression = ((KtParenthesizedExpression)result$iv).getExpression();
                    if (ktExpression == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtProperty");
                    }
                    psiElement = (PsiElement)((KtProperty)ktExpression);
                }
            }
            KtProperty replaced = (KtProperty)psiElement;
            if (this.getEditor() != null && moveCaret) {
                CaretModel caretModel = this.getEditor().getCaretModel();
                PsiElement psiElement3 = replaced.getNameIdentifier();
                Intrinsics.checkNotNull((Object)psiElement3);
                caretModel.moveToOffset(PsiUtilsKt.getEndOffset((PsiElement)psiElement3));
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void performRefactoring(@NotNull Collection<? extends CallableDescriptor> descriptorsForChange) {
            Intrinsics.checkNotNullParameter(descriptorsForChange, (String)"descriptorsForChange");
            MultiMap conflicts = new MultiMap();
            String string = ((FunctionDescriptor)this.getCallableDescriptor()).getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            String getterName = JvmAbi.getterName((String)string);
            Collection<PsiElement> callables2 = CallableRefactoringKt.getAffectedCallables(this.getProject(), descriptorsForChange);
            PsiElement mainElement = this.findMainElement(callables2);
            ArrayList<KtCallElement> kotlinCalls = new ArrayList<KtCallElement>();
            ArrayList<PsiReference> kotlinRefsToRename = new ArrayList<PsiReference>();
            ArrayList<PsiReference> foreignRefs = new ArrayList<PsiReference>();
            Iterator<PsiElement> iterator2 = callables2.iterator();
            while (iterator2.hasNext()) {
                Query usages2;
                LexicalScope lexicalScope;
                PsiElement callable;
                Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
                if (!(callable instanceof PsiNamedElement)) continue;
                if (!this.checkModifiable(callable)) {
                    KotlinRefactoringUtilKt.reportDeclarationConflict((MultiMap<PsiElement, String>)conflicts, callable, (Function1<? super String, String>)((Function1)Converter::performRefactoring$lambda$0));
                }
                if (callable instanceof KtNamedFunction && (lexicalScope = CallableRefactoringKt.getContainingScope((DeclarationDescriptor)this.getCallableDescriptor())) != null) {
                    HierarchicalScope hierarchicalScope = (HierarchicalScope)lexicalScope;
                    Name name2 = ((FunctionDescriptor)this.getCallableDescriptor()).getName();
                    Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"getName(...)");
                    VariableDescriptor variableDescriptor = ScopeUtilsKt.findVariable$default((HierarchicalScope)hierarchicalScope, (Name)name2, (LookupLocation)((LookupLocation)NoLookupLocation.FROM_IDE), null, (int)4, null);
                    if (variableDescriptor != null) {
                        VariableDescriptor variableDescriptor2;
                        VariableDescriptor variableDescriptor3;
                        VariableDescriptor it = variableDescriptor3 = variableDescriptor;
                        boolean bl = false;
                        Object object = variableDescriptor2 = Intrinsics.areEqual((Object)UtilsKt.receiverType((CallableDescriptor)it), (Object)UtilsKt.receiverType(this.getCallableDescriptor())) ? variableDescriptor3 : null;
                        if (variableDescriptor2 != null) {
                            VariableDescriptor it2 = variableDescriptor2;
                            boolean bl2 = false;
                            variableDescriptor3 = DescriptorToSourceUtilsIde.INSTANCE.getAnyDeclaration(this.getProject(), (DeclarationDescriptor)it2);
                            if (variableDescriptor3 != null) {
                                it2 = variableDescriptor3;
                                boolean bl3 = false;
                                KotlinRefactoringUtilKt.reportDeclarationConflict((MultiMap<PsiElement, String>)conflicts, (PsiElement)it2, (Function1<? super String, String>)((Function1)Converter::performRefactoring$lambda$3$0));
                            }
                        }
                    }
                }
                if (callable instanceof PsiMethod) {
                    KotlinRefactoringUtilKt.checkDeclarationConflict((PsiMethod)callable, getterName, (MultiMap<PsiElement, String>)conflicts, callables2);
                }
                Intrinsics.checkNotNullExpressionValue((Object)ReferencesSearch.search((PsiElement)callable), (String)"search(...)");
                for (PsiReference usage : usages2.asIterable()) {
                    boolean bl;
                    if (usage instanceof KtSimpleNameReference) {
                        void $this$getParentOfType$iv$iv;
                        void $this$getParentOfTypeAndBranch_u24default$iv;
                        KtSimpleNameExpression expression = (KtSimpleNameExpression)((KtSimpleNameReference)usage).getExpression();
                        PsiElement it = (PsiElement)expression;
                        Function1 branch$iv = Converter::performRefactoring$lambda$4;
                        boolean strict$iv = false;
                        boolean $i$f$getParentOfTypeAndBranch = false;
                        void var20_22 = $this$getParentOfTypeAndBranch_u24default$iv;
                        boolean strict$iv$iv = strict$iv;
                        boolean $i$f$getParentOfType = false;
                        PsiElement psiElement = PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv$iv, KtCallElement.class, (boolean)strict$iv$iv);
                        KtCallElement callElement = (KtCallElement)(psiElement != null ? PsiUtilsKt.getIfChildIsInBranch((PsiElement)psiElement, (PsiElement)$this$getParentOfTypeAndBranch_u24default$iv, (Function1)branch$iv) : null);
                        if (callElement != null) {
                            PsiElement $this$getStrictParentOfType$iv = (PsiElement)expression;
                            boolean $i$f$getStrictParentOfType = false;
                            if (PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtCallableReferenceExpression.class, (boolean)true) == null) {
                                Object[] objectArray;
                                List list2 = callElement.getTypeArguments();
                                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getTypeArguments(...)");
                                if (!((Collection)list2).isEmpty()) {
                                    objectArray = new Object[1];
                                    Intrinsics.checkNotNullExpressionValue((Object)StringUtil.htmlEmphasize((String)callElement.getText()), (String)"htmlEmphasize(...)");
                                    conflicts.putValue((Object)callElement, (Object)KotlinBundle.message((String)"type.arguments.will.be.lost.after.conversion.0", (Object[])objectArray));
                                }
                                List list3 = callElement.getValueArguments();
                                Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getValueArguments(...)");
                                if (!((Collection)list3).isEmpty()) {
                                    objectArray = new Object[1];
                                    Intrinsics.checkNotNullExpressionValue((Object)StringUtil.htmlEmphasize((String)callElement.getText()), (String)"htmlEmphasize(...)");
                                    conflicts.putValue((Object)callElement, (Object)KotlinBundle.message((String)"call.with.arguments.will.be.skipped.0", (Object[])objectArray));
                                    continue;
                                }
                                bl = kotlinCalls.add(callElement);
                                continue;
                            }
                        }
                        bl = kotlinRefsToRename.add(usage);
                        continue;
                    }
                    bl = foreignRefs.add(usage);
                }
            }
            KotlinCommonRefactoringUtilKt.checkConflictsInteractively$default(this.getProject(), conflicts, null, () -> Converter.performRefactoring$lambda$5(this, ConvertFunctionToPropertyIntention.this, kotlinCalls, kotlinRefsToRename, foreignRefs, callables2, mainElement), 2, null);
        }

        private final PsiElement findMainElement(Collection<? extends PsiElement> callables2) {
            Object v0;
            block2: {
                if (this.getEditor() == null) {
                    return null;
                }
                int offset = this.getEditor().getCaretModel().getOffset();
                Iterable iterable = callables2;
                for (Object t : iterable) {
                    PsiElement it = (PsiElement)t;
                    boolean bl = false;
                    if (!(Intrinsics.areEqual((Object)this.file, (Object)it.getContainingFile()) && it.getTextRange().contains(offset))) continue;
                    v0 = t;
                    break block2;
                }
                v0 = null;
            }
            return v0;
        }

        private static final String newName_delegate$lambda$0(Converter this$0) {
            Name name2 = ((FunctionDescriptor)this$0.getCallableDescriptor()).getName();
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"getName(...)");
            Name name3 = name2;
            Name name4 = PropertiesConventionUtilKt.propertyNameByGetMethodName((Name)name3);
            if (name4 == null) {
                name4 = name3;
            }
            String string = name4.asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            return string;
        }

        private static final Unit convertFunction$lambda$0$4$0(KtBlockExpression $body, StringBuilder $this$transform) {
            Intrinsics.checkNotNullParameter((Object)$this$transform, (String)"$this$transform");
            $this$transform.append("\nget() ");
            $this$transform.append($body.getText());
            return Unit.INSTANCE;
        }

        private static final String performRefactoring$lambda$0(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Object[] objectArray = new Object[]{it};
            return KotlinBundle.message((String)"can.t.modify.0", (Object[])objectArray);
        }

        private static final String performRefactoring$lambda$3$0(String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            Object[] objectArray = new Object[]{s};
            return KotlinBundle.message((String)"0.already.exists", (Object[])objectArray);
        }

        private static final PsiElement performRefactoring$lambda$4(KtCallElement $this$getParentOfTypeAndBranch) {
            Intrinsics.checkNotNullParameter((Object)$this$getParentOfTypeAndBranch, (String)"$this$getParentOfTypeAndBranch");
            return (PsiElement)$this$getParentOfTypeAndBranch.getCalleeExpression();
        }

        private static final Unit performRefactoring$lambda$5(Converter this$0, ConvertFunctionToPropertyIntention this$1, ArrayList $kotlinCalls, ArrayList $kotlinRefsToRename, ArrayList $foreignRefs, Collection $callables, PsiElement $mainElement) {
            ApplicationUtilsKt.executeWriteCommand(this$0.getProject(), this$1.getText(), (Function0<Unit>)((Function0)() -> Converter.performRefactoring$lambda$5$0(this$0, $kotlinCalls, $kotlinRefsToRename, $foreignRefs, $callables, $mainElement)));
            return Unit.INSTANCE;
        }

        private static final Unit performRefactoring$lambda$5$0(Converter this$0, ArrayList $kotlinCalls, ArrayList $kotlinRefsToRename, ArrayList $foreignRefs, Collection $callables, PsiElement $mainElement) {
            KtCallElement it;
            KtPsiFactory psiFactory = new KtPsiFactory(this$0.getProject(), false, 2, null);
            String newGetterName = JvmAbi.getterName((String)this$0.getNewName());
            KtExpression newRefExpr = psiFactory.createExpression(this$0.getNewName());
            Iterable $this$forEach$iv = $kotlinCalls;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (KtCallElement)element$iv;
                boolean bl = false;
                it.replace((PsiElement)newRefExpr);
            }
            $this$forEach$iv = $kotlinRefsToRename;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (PsiReference)element$iv;
                boolean bl = false;
                it.handleElementRename(this$0.getNewName());
            }
            $this$forEach$iv = $foreignRefs;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (PsiReference)element$iv;
                boolean bl = false;
                it.handleElementRename(newGetterName);
            }
            $this$forEach$iv = $callables;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (PsiElement)element$iv;
                boolean bl = false;
                KtCallElement ktCallElement = it;
                if (ktCallElement instanceof KtNamedFunction) {
                    this$0.convertFunction((KtNamedFunction)it, psiFactory, Intrinsics.areEqual((Object)it, (Object)$mainElement));
                    continue;
                }
                if (!(ktCallElement instanceof PsiMethod)) continue;
                ((PsiMethod)it).setName(newGetterName);
            }
            ShortenReferences.process$default(ShortenReferences.DEFAULT, this$0.elementsToShorten, null, false, 6, null);
            return Unit.INSTANCE;
        }
    }
}

