/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc;

import java.util.HashMap;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.protocol.LoginProtocolFactory;
import org.keycloak.protocol.oid4vc.OID4VCEnvironmentProviderFactory;
import org.keycloak.protocol.oid4vc.issuance.OID4VCIssuerEndpoint;
import org.keycloak.protocol.oid4vc.issuance.mappers.OID4VCSubjectIdMapper;
import org.keycloak.protocol.oid4vc.issuance.mappers.OID4VCUserAttributeMapper;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ClientScopeRepresentation;

public class OID4VCLoginProtocolFactory
implements LoginProtocolFactory,
OID4VCEnvironmentProviderFactory {
    private static final Logger LOGGER = Logger.getLogger(OID4VCLoginProtocolFactory.class);
    private static final String CLIENT_ROLES_MAPPER = "client-roles";
    private static final String USERNAME_MAPPER = "username";
    private static final String SUBJECT_ID_MAPPER = "subject-id";
    private static final String EMAIL_MAPPER = "email";
    private static final String LAST_NAME_MAPPER = "last-name";
    private static final String FIRST_NAME_MAPPER = "first-name";
    public static final String PROTOCOL_ID = "oid4vc";
    private final Map<String, ProtocolMapperModel> builtins = new HashMap<String, ProtocolMapperModel>();

    public void init(Config.Scope config) {
        this.builtins.put(SUBJECT_ID_MAPPER, OID4VCSubjectIdMapper.create("subject id", "id"));
        this.builtins.put(USERNAME_MAPPER, OID4VCUserAttributeMapper.create(USERNAME_MAPPER, USERNAME_MAPPER, USERNAME_MAPPER, false));
        this.builtins.put(EMAIL_MAPPER, OID4VCUserAttributeMapper.create(EMAIL_MAPPER, EMAIL_MAPPER, EMAIL_MAPPER, false));
        this.builtins.put(FIRST_NAME_MAPPER, OID4VCUserAttributeMapper.create(FIRST_NAME_MAPPER, "firstName", "firstName", false));
        this.builtins.put(LAST_NAME_MAPPER, OID4VCUserAttributeMapper.create(LAST_NAME_MAPPER, "lastName", "familyName", false));
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public Map<String, ProtocolMapperModel> getBuiltinMappers() {
        return this.builtins;
    }

    public Object createProtocolEndpoint(KeycloakSession keycloakSession, EventBuilder event) {
        return new OID4VCIssuerEndpoint(keycloakSession);
    }

    public void createDefaultClientScopes(RealmModel newRealm, boolean addScopesToExistingClients) {
        LOGGER.debugf("Create default scopes for realm %s", (Object)newRealm.getName());
        ClientScopeModel naturalPersonScope = KeycloakModelUtils.getClientScopeByName((RealmModel)newRealm, (String)"natural_person");
        if (naturalPersonScope == null) {
            LOGGER.debug((Object)"Add natural person scope");
            naturalPersonScope = newRealm.addClientScope(String.format("%s_%s", PROTOCOL_ID, "natural_person"));
            naturalPersonScope.setDescription("OID4VCI Scope, that adds properties required for a natural person.");
            naturalPersonScope.setProtocol(PROTOCOL_ID);
            naturalPersonScope.addProtocolMapper(this.builtins.get(SUBJECT_ID_MAPPER));
            naturalPersonScope.addProtocolMapper(this.builtins.get(EMAIL_MAPPER));
            naturalPersonScope.addProtocolMapper(this.builtins.get(FIRST_NAME_MAPPER));
            naturalPersonScope.addProtocolMapper(this.builtins.get(LAST_NAME_MAPPER));
            this.addClientScopeDefaults(naturalPersonScope);
            newRealm.addDefaultClientScope(naturalPersonScope, true);
        }
    }

    public void setupClientDefaults(ClientRepresentation rep, ClientModel newClient) {
    }

    public void addClientScopeDefaults(ClientScopeRepresentation clientScope) {
        clientScope.getAttributes().putIfAbsent("include.in.token.scope", "true");
        clientScope.getAttributes().putIfAbsent("vc.include_in_metadata", "true");
        clientScope.getAttributes().computeIfAbsent("vc.credential_configuration_id", k -> clientScope.getName());
        clientScope.getAttributes().computeIfAbsent("vc.credential_identifier", k -> clientScope.getName());
        clientScope.getAttributes().computeIfAbsent("vc.supported_credential_types", k -> clientScope.getName());
        clientScope.getAttributes().computeIfAbsent("vc.credential_contexts", k -> clientScope.getName());
        clientScope.getAttributes().computeIfAbsent("vc.verifiable_credential_type", k -> clientScope.getName());
        clientScope.getAttributes().computeIfAbsent("vc.format", k -> "dc+sd-jwt");
        clientScope.getAttributes().computeIfAbsent("vc.cryptographic_binding_methods_supported", k -> "jwk");
        clientScope.getAttributes().computeIfAbsent("vc.sd_jwt.number_of_decoys", k -> String.valueOf(10));
        clientScope.getAttributes().computeIfAbsent("vc.credential_build_config.sd_jwt.visible_claims", k -> "id,iat,nbf,exp,jti");
        clientScope.getAttributes().computeIfAbsent("vc.credential_build_config.hash_algorithm", k -> "SHA-256");
        clientScope.getAttributes().computeIfAbsent("vc.credential_build_config.token_jws_type", k -> "JWS");
        clientScope.getAttributes().computeIfAbsent("vc.expiry_in_seconds", k -> String.valueOf(31536000));
    }

    public LoginProtocol create(KeycloakSession session) {
        return null;
    }

    public String getId() {
        return PROTOCOL_ID;
    }

    public int order() {
        return 80;
    }

    private void addClientScopeDefaults(ClientScopeModel clientScope) {
        ClientScopeRepresentation clientScopeRep = ModelToRepresentation.toRepresentation((ClientScopeModel)clientScope);
        this.addClientScopeDefaults(clientScopeRep);
        RepresentationToModel.updateClientScope((ClientScopeRepresentation)clientScopeRep, (ClientScopeModel)clientScope);
    }
}

