/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.resthandlerv2;

import java.time.Instant;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.alerting.AlertingPlugin;
import org.opensearch.alerting.actionv2.ExecuteMonitorV2Action;
import org.opensearch.alerting.actionv2.ExecuteMonitorV2Request;
import org.opensearch.alerting.modelv2.MonitorV2;
import org.opensearch.alerting.resthandlerv2.RestExecuteMonitorV2ActionKt;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.commons.alerting.util.AlertingException;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.transport.client.node.NodeClient;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010H\u0014\u00a8\u0006\u0011"}, d2={"Lorg/opensearch/alerting/resthandlerv2/RestExecuteMonitorV2Action;", "Lorg/opensearch/rest/BaseRestHandler;", "<init>", "()V", "getName", "", "routes", "", "Lorg/opensearch/rest/RestHandler$Route;", "prepareRequest", "Lorg/opensearch/rest/BaseRestHandler$RestChannelConsumer;", "request", "Lorg/opensearch/rest/RestRequest;", "client", "Lorg/opensearch/transport/client/node/NodeClient;", "responseParams", "", "opensearch-alerting"})
public final class RestExecuteMonitorV2Action
extends BaseRestHandler {
    @NotNull
    public String getName() {
        return "execute_monitor_v2_action";
    }

    @NotNull
    public List<RestHandler.Route> routes() {
        Object[] objectArray = new RestHandler.Route[]{new RestHandler.Route(RestRequest.Method.POST, AlertingPlugin.MONITOR_V2_BASE_URI + "/{monitor_id}/_execute"), new RestHandler.Route(RestRequest.Method.POST, AlertingPlugin.MONITOR_V2_BASE_URI + "/_execute")};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    protected BaseRestHandler.RestChannelConsumer prepareRequest(@NotNull RestRequest request, @NotNull NodeClient client) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        RestExecuteMonitorV2ActionKt.access$getLog$p().debug(request.method() + " " + AlertingPlugin.MONITOR_V2_BASE_URI + "/_execute");
        return arg_0 -> RestExecuteMonitorV2Action.prepareRequest$lambda$0(request, client, arg_0);
    }

    @NotNull
    protected Set<String> responseParams() {
        Object[] objectArray = new String[]{"dryrun", "period_end", "monitor_id"};
        return SetsKt.setOf((Object[])objectArray);
    }

    private static final void prepareRequest$lambda$0(RestRequest $request, NodeClient $client, RestChannel channel) {
        boolean dryrun = $request.paramAsBoolean("dryrun", false);
        TimeValue requestEnd = $request.paramAsTime("period_end", new TimeValue(Instant.now().toEpochMilli()));
        if ($request.hasParam("monitor_id")) {
            String monitorV2Id = $request.param("monitor_id");
            Intrinsics.checkNotNull((Object)requestEnd);
            ExecuteMonitorV2Request execMonitorV2Request = new ExecuteMonitorV2Request(dryrun, true, monitorV2Id, null, requestEnd);
            $client.execute((ActionType)ExecuteMonitorV2Action.Companion.getINSTANCE(), (ActionRequest)execMonitorV2Request, (ActionListener)new RestToXContentListener(channel));
        } else {
            XContentParser xcp = $request.contentParser();
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
            MonitorV2 monitorV2 = null;
            try {
                Intrinsics.checkNotNull((Object)xcp);
                monitorV2 = MonitorV2.Companion.parse$default(MonitorV2.Companion, xcp, null, 0L, 6, null);
            }
            catch (Exception e) {
                throw AlertingException.Companion.wrap(e);
            }
            Intrinsics.checkNotNull((Object)requestEnd);
            ExecuteMonitorV2Request execMonitorV2Request = new ExecuteMonitorV2Request(dryrun, true, null, monitorV2, requestEnd);
            $client.execute((ActionType)ExecuteMonitorV2Action.Companion.getINSTANCE(), (ActionRequest)execMonitorV2Request, (ActionListener)new RestToXContentListener(channel));
        }
    }
}

