/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.transport;

import java.io.IOException;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.action.support.nodes.BaseNodesRequest;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;

public class DeleteModelRequest
extends BaseNodesRequest<DeleteModelRequest>
implements ToXContentObject {
    private String configID;

    public String getAdID() {
        return this.configID;
    }

    public DeleteModelRequest() {
        super((String[])null);
    }

    public DeleteModelRequest(StreamInput in) throws IOException {
        super(in);
        this.configID = in.readString();
    }

    public DeleteModelRequest(String adID, DiscoveryNode ... nodes) {
        super(nodes);
        this.configID = adID;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.configID);
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (Strings.isEmpty((CharSequence)this.configID)) {
            validationException = ValidateActions.addValidationError((String)"config ID is missing", validationException);
        }
        return validationException;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("config_id", this.configID);
        builder.endObject();
        return builder;
    }
}

