/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.parkservices.calibration;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.PredictiveRandomCutForest;
import com.amazon.randomcutforest.config.TransformMethod;
import com.amazon.randomcutforest.parkservices.ForecastDescriptor;
import com.amazon.randomcutforest.parkservices.RCFCaster;
import com.amazon.randomcutforest.parkservices.config.Calibration;
import com.amazon.randomcutforest.returntypes.DiVector;
import com.amazon.randomcutforest.returntypes.RangeVector;
import com.amazon.randomcutforest.returntypes.SampleSummary;
import com.amazon.randomcutforest.statistics.Deviation;
import java.util.Arrays;
import java.util.Optional;
import lombok.Generated;

public class ErrorHandler {
    int sequenceIndex;
    double percentile;
    int forecastHorizon;
    int errorHorizon;
    protected RangeVector[] pastForecasts;
    RangeVector errorDistribution;
    DiVector errorRMSE;
    float[] errorMean;
    Deviation[] intervalPrecision;
    Deviation[] rmseHighDeviations;
    Deviation[] rmseLowDeviations;
    float[] lowerLimit;
    float[] upperLimit;
    double[] lastInputs;
    PredictiveRandomCutForest estimator;
    float[] lastDataDeviations;
    RangeVector multipliers;
    RangeVector adders;

    public ErrorHandler(Builder builder) {
        int i;
        CommonUtils.checkArgument((builder.forecastHorizon > 0 ? 1 : 0) != 0, (String)"has to be positive");
        CommonUtils.checkArgument((builder.errorHorizon >= builder.forecastHorizon ? 1 : 0) != 0, (String)"intervalPrecision horizon should be at least as large as forecast horizon");
        CommonUtils.checkArgument((builder.errorHorizon <= 1024 ? 1 : 0) != 0, (String)"reduce error horizon");
        this.forecastHorizon = builder.forecastHorizon;
        this.errorHorizon = builder.errorHorizon;
        int inputLength = builder.dimensions / builder.shingleSize;
        int length = inputLength * this.forecastHorizon;
        this.percentile = builder.percentile;
        this.pastForecasts = new RangeVector[this.forecastHorizon];
        for (i = 0; i < this.forecastHorizon; ++i) {
            this.pastForecasts[i] = new RangeVector(length);
        }
        this.sequenceIndex = 0;
        this.lastInputs = new double[2 * inputLength];
        this.rmseHighDeviations = new Deviation[length];
        this.rmseLowDeviations = new Deviation[length];
        this.intervalPrecision = new Deviation[length];
        for (i = 0; i < length; ++i) {
            this.rmseHighDeviations[i] = new Deviation(1.0 / (double)this.errorHorizon);
            this.rmseLowDeviations[i] = new Deviation(1.0 / (double)this.errorHorizon);
            this.intervalPrecision[i] = new Deviation(1.0 / (double)this.errorHorizon);
        }
        this.errorMean = new float[length];
        this.errorRMSE = new DiVector(length);
        this.lastDataDeviations = new float[inputLength];
        this.errorDistribution = new RangeVector(length);
        if (builder.upperLimit.isPresent()) {
            CommonUtils.checkArgument((builder.upperLimit.get().length == inputLength ? 1 : 0) != 0, (String)"incorrect length");
            this.upperLimit = Arrays.copyOf(builder.upperLimit.get(), inputLength);
        } else {
            this.upperLimit = new float[inputLength];
            Arrays.fill(this.upperLimit, Float.MAX_VALUE);
        }
        if (builder.lowerLimit.isPresent()) {
            CommonUtils.checkArgument((builder.lowerLimit.get().length == inputLength ? 1 : 0) != 0, (String)"incorrect length");
            for (int y = 0; y < inputLength; ++y) {
                CommonUtils.checkArgument((builder.lowerLimit.get()[y] <= this.upperLimit[y] ? 1 : 0) != 0, (String)"incorrect limits");
            }
            this.lowerLimit = Arrays.copyOf(builder.lowerLimit.get(), inputLength);
        } else {
            this.lowerLimit = new float[inputLength];
            Arrays.fill(this.lowerLimit, -3.4028235E38f);
        }
        if (builder.useRCF) {
            int inputDimensions = this.lastInputs.length + 2 * inputLength + 2;
            double[] weights = new double[inputDimensions];
            Arrays.fill(weights, 1.0);
            weights[this.lastInputs.length] = this.lastInputs.length;
            weights[this.lastInputs.length + 1] = this.lastInputs.length;
            this.estimator = new PredictiveRandomCutForest.Builder().inputDimensions(inputDimensions).weights(weights).randomSeed(13L).outputAfter(50).transformMethod(TransformMethod.NORMALIZE).startNormalization(49).build();
        }
    }

    public ErrorHandler(int errorHorizon, int forecastHorizon, int sequenceIndex, double percentile, int inputLength, float[] pastForecastsFlattened, float[] lastDataDeviations, double[] lastInput, Deviation[] deviations, PredictiveRandomCutForest estimator, float[] auxiliary) {
        int i;
        CommonUtils.checkArgument((forecastHorizon > 0 ? 1 : 0) != 0, (String)" incorrect forecast horizon");
        CommonUtils.checkArgument((errorHorizon >= forecastHorizon ? 1 : 0) != 0, (String)"incorrect error horizon");
        CommonUtils.checkArgument((inputLength > 0 ? 1 : 0) != 0, (String)"incorrect parameters");
        CommonUtils.checkArgument((sequenceIndex >= 0 ? 1 : 0) != 0, (String)"cannot be negative");
        CommonUtils.checkArgument((Math.abs(percentile - 0.25) < 0.24 ? 1 : 0) != 0, (String)"has to be between (0,0.5) ");
        CommonUtils.checkArgument((deviations.length == 3 * inputLength * forecastHorizon ? 1 : 0) != 0, (String)"incorrect length");
        CommonUtils.checkArgument((lastInput.length == 2 * inputLength ? 1 : 0) != 0, (String)"incorrect length");
        this.sequenceIndex = sequenceIndex;
        this.errorHorizon = errorHorizon;
        this.percentile = percentile;
        this.forecastHorizon = forecastHorizon;
        this.pastForecasts = new RangeVector[forecastHorizon];
        this.lastInputs = Arrays.copyOf(lastInput, lastInput.length);
        int length = forecastHorizon * inputLength;
        CommonUtils.checkArgument((lastDataDeviations.length >= inputLength ? 1 : 0) != 0, (String)"incorrect length");
        this.lastDataDeviations = Arrays.copyOf(lastDataDeviations, lastDataDeviations.length);
        this.errorMean = new float[length];
        this.errorRMSE = new DiVector(length);
        this.errorDistribution = new RangeVector(length);
        this.intervalPrecision = new Deviation[inputLength * forecastHorizon];
        this.rmseHighDeviations = new Deviation[inputLength * forecastHorizon];
        this.rmseLowDeviations = new Deviation[inputLength * forecastHorizon];
        for (int y = 0; y < inputLength * forecastHorizon; ++y) {
            this.intervalPrecision[y] = deviations[y].copy();
            this.rmseHighDeviations[y] = deviations[y + inputLength * forecastHorizon].copy();
            this.rmseLowDeviations[y] = deviations[y + 2 * inputLength * forecastHorizon].copy();
        }
        this.lowerLimit = new float[inputLength];
        Arrays.fill(this.lowerLimit, -3.4028235E38f);
        this.upperLimit = new float[inputLength];
        Arrays.fill(this.upperLimit, Float.MAX_VALUE);
        this.estimator = estimator;
        int arrayLength = pastForecastsFlattened.length / (3 * length);
        CommonUtils.checkArgument((arrayLength * 3 * length == pastForecastsFlattened.length ? 1 : 0) != 0, (String)" has to be multiple of 3");
        for (i = 0; i < arrayLength; ++i) {
            float[] values = Arrays.copyOfRange(pastForecastsFlattened, i * 3 * length, (i * 3 + 1) * length);
            float[] upper = Arrays.copyOfRange(pastForecastsFlattened, (i * 3 + 1) * length, (i * 3 + 2) * length);
            float[] lower = Arrays.copyOfRange(pastForecastsFlattened, (i * 3 + 2) * length, (i * 3 + 3) * length);
            this.pastForecasts[i] = new RangeVector(values, upper, lower);
        }
        for (i = arrayLength; i < forecastHorizon; ++i) {
            this.pastForecasts[i] = new RangeVector(length);
        }
        this.recomputeErrors(this.lastInputs, inputLength);
    }

    public void setUpperLimit(float[] upperLimit) {
        if (upperLimit != null) {
            CommonUtils.checkArgument((upperLimit.length == this.upperLimit.length ? 1 : 0) != 0, (String)"incorrect Length");
            System.arraycopy(upperLimit, 0, this.upperLimit, 0, upperLimit.length);
        }
    }

    public void setLowerLimit(float[] lowerLimit) {
        if (lowerLimit != null) {
            CommonUtils.checkArgument((lowerLimit.length == this.lowerLimit.length ? 1 : 0) != 0, (String)"incorrect Length");
            for (int i = 0; i < lowerLimit.length; ++i) {
                CommonUtils.checkArgument((lowerLimit[i] <= this.upperLimit[i] ? 1 : 0) != 0, (String)"lower limit is higher than upper limit");
                this.lowerLimit[i] = lowerLimit[i];
            }
        }
    }

    public void updateActuals(double[] input, double[] deviations) {
        int arrayLength = this.pastForecasts.length;
        int inputLength = input.length;
        for (int i = 0; i < this.lastInputs.length - inputLength; ++i) {
            this.lastInputs[i] = this.lastInputs[i + inputLength];
        }
        System.arraycopy(input, 0, this.lastInputs, this.lastInputs.length - inputLength, inputLength);
        if (this.sequenceIndex > 0) {
            int inputIndex = (this.sequenceIndex + arrayLength - 1) % arrayLength;
            float[] errorTuple = new float[this.lastInputs.length + 2 * inputLength + 2];
            for (int y = 0; y < this.lastInputs.length; ++y) {
                errorTuple[y] = (float)this.lastInputs[y];
            }
            for (int i = 0; i < this.forecastHorizon; ++i) {
                if (this.sequenceIndex > i) {
                    for (int j = 0; j < inputLength; ++j) {
                        RangeVector a = this.pastForecasts[inputIndex];
                        int offset = i * inputLength;
                        errorTuple[this.lastInputs.length] = i;
                        errorTuple[this.lastInputs.length + 1] = this.forecastHorizon - i;
                        if (input[j] <= (double)a.upper[offset + j] && input[j] >= (double)a.lower[offset + j]) {
                            this.intervalPrecision[offset + j].update(1.0);
                        } else {
                            this.intervalPrecision[offset + j].update(0.0);
                        }
                        double error = input[j] - (double)a.values[offset + j];
                        if (error >= 0.0) {
                            this.rmseHighDeviations[offset + j].update(error);
                            this.rmseLowDeviations[offset + j].update(0.0);
                            errorTuple[this.lastInputs.length + 2 + j] = (float)error;
                            errorTuple[this.lastInputs.length + inputLength + 2 + j] = 0.0f;
                            continue;
                        }
                        this.rmseLowDeviations[offset + j].update(error);
                        this.rmseHighDeviations[offset + j].update(0.0);
                        errorTuple[this.lastInputs.length + inputLength + 2 + j] = (float)error;
                        errorTuple[this.lastInputs.length + 2 + j] = 0.0f;
                    }
                    if (this.estimator != null) {
                        this.estimator.update(errorTuple, 0L);
                    }
                }
                inputIndex = (inputIndex + arrayLength - 1) % arrayLength;
            }
        }
        this.lastDataDeviations = CommonUtils.toFloatArray((double[])deviations);
        this.recomputeErrors(this.lastInputs, inputLength);
    }

    void recomputeErrors(double[] lastInputs, int inputLength) {
        int i;
        int y;
        double a = this.estimator != null ? (double)this.sequenceIndex / (double)this.estimator.getForest().getOutputAfter() : (double)this.sequenceIndex / (double)(10 * this.forecastHorizon);
        float[] query = new float[lastInputs.length + inputLength * 2 + 2];
        System.arraycopy(CommonUtils.toFloatArray((double[])lastInputs), 0, query, 0, lastInputs.length);
        float[] errorHigh = new float[this.intervalPrecision.length];
        float[] errorLow = new float[this.intervalPrecision.length];
        if (a < 1.0) {
            for (y = 0; y < this.intervalPrecision.length; ++y) {
                this.errorRMSE.high[y] = this.errorRMSE.low[y] = (double)this.lastDataDeviations[y % inputLength];
                errorHigh[y] = errorLow[y] = this.lastDataDeviations[y % inputLength];
            }
        } else {
            if (a < 2.0) {
                for (y = 0; y < this.errorRMSE.high.length; ++y) {
                    double offset = (2.0 - a) * (double)this.lastDataDeviations[y % inputLength];
                    this.errorRMSE.high[y] = offset + (a - 1.0) * this.rmseHighDeviations[y].getDeviation();
                    this.errorRMSE.low[y] = offset + (a - 1.0) * this.rmseLowDeviations[y].getDeviation();
                }
            } else {
                for (y = 0; y < this.errorRMSE.high.length; ++y) {
                    this.errorRMSE.high[y] = this.rmseHighDeviations[y].getDeviation();
                    this.errorRMSE.low[y] = this.rmseLowDeviations[y].getDeviation();
                }
            }
            if (this.estimator != null) {
                for (i = 0; i < this.forecastHorizon; ++i) {
                    int j;
                    int[] missing = new int[inputLength];
                    query[lastInputs.length] = i;
                    query[lastInputs.length + 1] = this.forecastHorizon - i;
                    for (int j2 = 0; j2 < inputLength; ++j2) {
                        missing[j2] = lastInputs.length + 2 + j2;
                    }
                    SampleSummary answer = this.estimator.predict(query, 0L, missing, 1, 0.5, 0.7);
                    for (j = 0; j < inputLength; ++j) {
                        errorHigh[i * inputLength + j] = (float)(this.forecastHorizon - i) * Math.max(0.0f, answer.deviation[lastInputs.length + 2 + j]) / (float)this.forecastHorizon + (float)((double)i * this.rmseHighDeviations[i * inputLength + j].getDeviation() / (double)this.forecastHorizon);
                    }
                    for (j = 0; j < inputLength; ++j) {
                        missing[j] = lastInputs.length + inputLength + 2 + j;
                    }
                    answer = this.estimator.predict(query, 0L, missing, 1, 0.5, 0.7);
                    for (j = 0; j < inputLength; ++j) {
                        errorLow[i * inputLength + j] = (float)(this.forecastHorizon - i) * Math.max(0.0f, answer.deviation[lastInputs.length + inputLength + 2 + j]) / (float)this.forecastHorizon + (float)((double)i * this.rmseLowDeviations[i * inputLength + j].getDeviation() / (double)this.forecastHorizon);
                    }
                }
            } else {
                for (y = 0; y < this.errorRMSE.high.length; ++y) {
                    errorHigh[y] = (float)this.errorRMSE.high[y];
                    errorLow[y] = (float)this.errorRMSE.low[y];
                }
            }
        }
        for (y = 0; y < this.intervalPrecision.length; ++y) {
            if (!(this.intervalPrecision[y].getMean() < 1.0 - this.percentile)) continue;
            errorHigh[y] = (float)Math.max(1.0, 1.0 / (this.intervalPrecision[y].getMean() + 0.1)) * errorHigh[y];
            errorLow[y] = (float)Math.max(1.0, 1.0 / (this.intervalPrecision[y].getMean() + 0.1)) * errorLow[y];
        }
        for (i = 0; i < this.errorMean.length; ++i) {
            this.errorMean[i] = (float)(this.rmseHighDeviations[i].getMean() + this.rmseLowDeviations[i].getMean());
            this.errorDistribution.values[i] = this.errorMean[i];
            this.errorDistribution.upper[i] = this.errorMean[i] + (float)(1.3 * (double)errorHigh[i]);
            this.errorDistribution.lower[i] = this.errorMean[i] - (float)(1.3 * (double)errorLow[i]);
        }
    }

    public void augmentDescriptor(ForecastDescriptor descriptor) {
        int inputLength = descriptor.getInputLength();
        float[] iPrecision = new float[inputLength * this.forecastHorizon];
        for (int i = 0; i < this.errorMean.length; ++i) {
            iPrecision[i] = (float)this.intervalPrecision[i].getMean();
        }
        descriptor.setErrorMean(this.errorMean);
        descriptor.setErrorRMSE(this.errorRMSE);
        descriptor.setObservedErrorDistribution(this.errorDistribution);
        descriptor.setIntervalPrecision(iPrecision);
    }

    public void updateForecasts(RangeVector vector) {
        ++this.sequenceIndex;
        int arrayLength = this.pastForecasts.length;
        int storedForecastIndex = (this.sequenceIndex + arrayLength - 1) % arrayLength;
        int length = this.pastForecasts[0].values.length;
        System.arraycopy(vector.values, 0, this.pastForecasts[storedForecastIndex].values, 0, length);
        System.arraycopy(vector.upper, 0, this.pastForecasts[storedForecastIndex].upper, 0, length);
        System.arraycopy(vector.lower, 0, this.pastForecasts[storedForecastIndex].lower, 0, length);
    }

    public RangeVector getErrorDistribution() {
        return new RangeVector(this.errorDistribution);
    }

    public float[] getErrorMean() {
        return Arrays.copyOf(this.errorMean, this.errorMean.length);
    }

    public DiVector getErrorRMSE() {
        return new DiVector(this.errorRMSE);
    }

    public Deviation[] getDeviationList() {
        Deviation[] list = new Deviation[3 * this.intervalPrecision.length];
        for (int i = 0; i < this.intervalPrecision.length; ++i) {
            list[i] = this.intervalPrecision[i].copy();
            list[i + this.intervalPrecision.length] = this.rmseHighDeviations[i].copy();
            list[i + 2 * this.intervalPrecision.length] = this.rmseLowDeviations[i].copy();
        }
        return list;
    }

    public float[] getIntervalPrecision() {
        float[] iPrecision = new float[this.intervalPrecision.length];
        for (int i = 0; i < iPrecision.length; ++i) {
            iPrecision[i] = (float)this.intervalPrecision[i].getMean();
        }
        return iPrecision;
    }

    public void calibrate(double[] input, Calibration calibration, RangeVector ranges) {
        if (calibration != Calibration.NONE) {
            int inputLength = this.intervalPrecision.length / this.forecastHorizon;
            CommonUtils.checkArgument((input.length == inputLength ? 1 : 0) != 0, (String)"incorrect input");
            CommonUtils.checkArgument((this.intervalPrecision.length == ranges.values.length ? 1 : 0) != 0, (String)"mismatched lengths");
            for (int y = 0; y < this.intervalPrecision.length; ++y) {
                ranges.values[y] = calibration == Calibration.SIMPLE ? Math.min(Math.max(ranges.values[y] + this.errorDistribution.values[y], this.lowerLimit[y % inputLength]), this.upperLimit[y % inputLength]) : Math.min(Math.max(ranges.values[y], this.lowerLimit[y % inputLength]), this.upperLimit[y % inputLength]);
                ranges.upper[y] = Math.min(Math.max(ranges.upper[y], ranges.values[y] + this.errorDistribution.upper[y]), this.upperLimit[y % inputLength]);
                ranges.lower[y] = Math.max(Math.min(ranges.lower[y], ranges.values[y] + this.errorDistribution.lower[y]), this.lowerLimit[y % inputLength]);
            }
        }
    }

    public int getInputLength() {
        return this.lastInputs.length / 2;
    }

    public float[] getPastForecastsFlattened() {
        int arrayLength = Math.min(this.sequenceIndex, this.pastForecasts.length);
        int length = this.intervalPrecision.length;
        float[] answer = new float[3 * length * arrayLength];
        for (int i = 0; i < arrayLength; ++i) {
            System.arraycopy(this.pastForecasts[i].values, 0, answer, 3 * i * length, length);
            System.arraycopy(this.pastForecasts[i].upper, 0, answer, 3 * i * length + length, length);
            System.arraycopy(this.pastForecasts[i].lower, 0, answer, 3 * i * length + 2 * length, length);
        }
        return answer;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public int getSequenceIndex() {
        return this.sequenceIndex;
    }

    @Generated
    public double getPercentile() {
        return this.percentile;
    }

    @Generated
    public int getForecastHorizon() {
        return this.forecastHorizon;
    }

    @Generated
    public int getErrorHorizon() {
        return this.errorHorizon;
    }

    @Generated
    public RangeVector[] getPastForecasts() {
        return this.pastForecasts;
    }

    @Generated
    public Deviation[] getRmseHighDeviations() {
        return this.rmseHighDeviations;
    }

    @Generated
    public Deviation[] getRmseLowDeviations() {
        return this.rmseLowDeviations;
    }

    @Generated
    public float[] getLowerLimit() {
        return this.lowerLimit;
    }

    @Generated
    public float[] getUpperLimit() {
        return this.upperLimit;
    }

    @Generated
    public double[] getLastInputs() {
        return this.lastInputs;
    }

    @Generated
    public PredictiveRandomCutForest getEstimator() {
        return this.estimator;
    }

    @Generated
    public float[] getLastDataDeviations() {
        return this.lastDataDeviations;
    }

    @Generated
    public RangeVector getMultipliers() {
        return this.multipliers;
    }

    @Generated
    public RangeVector getAdders() {
        return this.adders;
    }

    @Generated
    public void setSequenceIndex(int sequenceIndex) {
        this.sequenceIndex = sequenceIndex;
    }

    @Generated
    public void setPercentile(double percentile) {
        this.percentile = percentile;
    }

    @Generated
    public void setForecastHorizon(int forecastHorizon) {
        this.forecastHorizon = forecastHorizon;
    }

    @Generated
    public void setErrorHorizon(int errorHorizon) {
        this.errorHorizon = errorHorizon;
    }

    @Generated
    public void setPastForecasts(RangeVector[] pastForecasts) {
        this.pastForecasts = pastForecasts;
    }

    @Generated
    public void setErrorDistribution(RangeVector errorDistribution) {
        this.errorDistribution = errorDistribution;
    }

    @Generated
    public void setErrorRMSE(DiVector errorRMSE) {
        this.errorRMSE = errorRMSE;
    }

    @Generated
    public void setErrorMean(float[] errorMean) {
        this.errorMean = errorMean;
    }

    @Generated
    public void setIntervalPrecision(Deviation[] intervalPrecision) {
        this.intervalPrecision = intervalPrecision;
    }

    @Generated
    public void setRmseHighDeviations(Deviation[] rmseHighDeviations) {
        this.rmseHighDeviations = rmseHighDeviations;
    }

    @Generated
    public void setRmseLowDeviations(Deviation[] rmseLowDeviations) {
        this.rmseLowDeviations = rmseLowDeviations;
    }

    @Generated
    public void setLastInputs(double[] lastInputs) {
        this.lastInputs = lastInputs;
    }

    @Generated
    public void setEstimator(PredictiveRandomCutForest estimator) {
        this.estimator = estimator;
    }

    @Generated
    public void setLastDataDeviations(float[] lastDataDeviations) {
        this.lastDataDeviations = lastDataDeviations;
    }

    @Generated
    public void setMultipliers(RangeVector multipliers) {
        this.multipliers = multipliers;
    }

    @Generated
    public void setAdders(RangeVector adders) {
        this.adders = adders;
    }

    public static class Builder {
        protected int dimensions;
        protected int shingleSize = 1;
        protected int forecastHorizon;
        protected boolean useRCF = true;
        protected int errorHorizon = 100;
        protected double percentile = RCFCaster.DEFAULT_ERROR_PERCENTILE;
        protected Optional<float[]> upperLimit = Optional.empty();
        protected Optional<float[]> lowerLimit = Optional.empty();

        public Builder dimensions(int dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public Builder shingleSize(int shingleSize) {
            this.shingleSize = shingleSize;
            return this;
        }

        public Builder forecastHorizon(int horizon) {
            this.forecastHorizon = horizon;
            return this;
        }

        public Builder errorHorizon(int errorHorizon) {
            this.errorHorizon = errorHorizon;
            return this;
        }

        public Builder percentile(double percentile) {
            this.percentile = percentile;
            return this;
        }

        public Builder lowerLimit(float[] lowerLimit) {
            this.lowerLimit = Optional.of(lowerLimit);
            return this;
        }

        public Builder upperLimit(float[] upperLimit) {
            this.upperLimit = Optional.of(upperLimit);
            return this;
        }

        public Builder useRCF(boolean use) {
            this.useRCF = use;
            return this;
        }

        public ErrorHandler build() {
            return new ErrorHandler(this);
        }
    }
}

