"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DynamicConfigService = void 0;
var _async_hooks = require("async_hooks");
var _operators = require("rxjs/operators");
var _internal_dynamic_configuration_client = require("./service/internal_dynamic_configuration_client");
var _utils = require("./utils/utils");
var _dynamic_configuration_client = require("./service/dynamic_configuration_client");
var _opensearch_config_store_factory = require("./service/config_store_client/opensearch_config_store_factory");
var _dummy_config_store_factory = require("./service/config_store_client/dummy_config_store_factory");
function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _classPrivateFieldSet(s, a, r) { return s.set(_assertClassBrand(s, a), r), r; }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); } /*
                                                                                                                                                                                                     * Copyright OpenSearch Contributors
                                                                                                                                                                                                     * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                     */
var _configService = /*#__PURE__*/new WeakMap();
var _envService = /*#__PURE__*/new WeakMap();
var _logger = /*#__PURE__*/new WeakMap();
var _schemas = /*#__PURE__*/new WeakMap();
var _config$ = /*#__PURE__*/new WeakMap();
var _asyncLocalStorage = /*#__PURE__*/new WeakMap();
var _requestHeaders = /*#__PURE__*/new WeakMap();
var _configStoreClientFactory = /*#__PURE__*/new WeakMap();
var _started = /*#__PURE__*/new WeakMap();
var _startPromiseResolver = /*#__PURE__*/new WeakMap();
var _startPromise = /*#__PURE__*/new WeakMap();
/** @internal */
class DynamicConfigService {
  constructor(configService, envService, logger) {
    _classPrivateFieldInitSpec(this, _configService, void 0);
    _classPrivateFieldInitSpec(this, _envService, void 0);
    _classPrivateFieldInitSpec(this, _logger, void 0);
    _classPrivateFieldInitSpec(this, _schemas, new Map());
    _classPrivateFieldInitSpec(this, _config$, void 0);
    _classPrivateFieldInitSpec(this, _asyncLocalStorage, new _async_hooks.AsyncLocalStorage());
    _classPrivateFieldInitSpec(this, _requestHeaders, []);
    _classPrivateFieldInitSpec(this, _configStoreClientFactory, void 0);
    _classPrivateFieldInitSpec(this, _started, false);
    _classPrivateFieldInitSpec(this, _startPromiseResolver, void 0);
    _classPrivateFieldInitSpec(this, _startPromise, void 0);
    _classPrivateFieldSet(_configService, this, configService);
    _classPrivateFieldSet(_envService, this, envService);
    _classPrivateFieldSet(_logger, this, logger.get('dynamic-config-service'));
    _classPrivateFieldSet(_startPromise, this, new Promise(resolve => _classPrivateFieldSet(_startPromiseResolver, this, resolve)));
    _classPrivateFieldSet(_config$, this, configService.atPath('dynamic_config_service').pipe((0, _operators.first)()));
  }
  async setup() {
    return {
      registerDynamicConfigClientFactory: factory => {
        if (_classPrivateFieldGet(_configStoreClientFactory, this)) {
          throw new Error('Dynamic config store client factory is already set');
        }
        if (_classPrivateFieldGet(_started, this)) {
          throw new Error('Cannot set config store client factory because dynamic configuration service has already started');
        }
        _classPrivateFieldSet(_configStoreClientFactory, this, factory);
      },
      registerAsyncLocalStoreRequestHeader: key => {
        if (typeof key === 'string') {
          _classPrivateFieldGet(_requestHeaders, this).push(key);
        } else {
          _classPrivateFieldGet(_requestHeaders, this).push(...key);
        }
      },
      getStartService: async () => {
        return await _classPrivateFieldGet(_startPromise, this);
      }
    };
  }
  async start({
    opensearch
  }) {
    _classPrivateFieldGet(_logger, this).info('initiating start()');
    const config = await _classPrivateFieldGet(_config$, this).pipe((0, _operators.first)()).toPromise();
    let configStoreClient;
    if (!config.enabled) {
      const dummyDynamicConfigStoreClientFactory = new _dummy_config_store_factory.DummyDynamicConfigStoreFactory();
      configStoreClient = dummyDynamicConfigStoreClientFactory.create();
    } else {
      if (_classPrivateFieldGet(_configStoreClientFactory, this)) {
        configStoreClient = _classPrivateFieldGet(_configStoreClientFactory, this).create();
      } else {
        const defaultDynamicConfigStoreClientFactory = new _opensearch_config_store_factory.OpenSearchDynamicConfigStoreFactory(opensearch);
        const defaultConfigStoreClient = defaultDynamicConfigStoreClientFactory.create();
        if (!config.skipMigrations) {
          await defaultConfigStoreClient.createDynamicConfigIndex();
        }
        configStoreClient = defaultConfigStoreClient;
      }
    }

    // Create the clients
    const internalClient = new _internal_dynamic_configuration_client.InternalDynamicConfigurationClient({
      client: configStoreClient,
      configService: _classPrivateFieldGet(_configService, this),
      env: _classPrivateFieldGet(_envService, this),
      logger: _classPrivateFieldGet(_logger, this),
      schemas: _classPrivateFieldGet(_schemas, this)
    });
    const client = new _dynamic_configuration_client.DynamicConfigurationClient(internalClient);
    const startServices = {
      getClient: () => {
        return client;
      },
      getAsyncLocalStore: () => {
        return _classPrivateFieldGet(_asyncLocalStorage, this).getStore();
      },
      createStoreFromRequest: request => {
        return (0, _utils.createLocalStoreFromOsdRequest)(_classPrivateFieldGet(_logger, this), request, _classPrivateFieldGet(_requestHeaders, this));
      }
    };
    _classPrivateFieldGet(_logger, this).info('finished start()');
    _classPrivateFieldSet(_started, this, true);
    if (_classPrivateFieldGet(_startPromiseResolver, this)) {
      _classPrivateFieldGet(_startPromiseResolver, this).call(this, startServices);
    }
    return startServices;
  }

  /**
   * Extra setup step to register any HTTP routes and the async local store. This should be called after all plugins are setup but before dynamicConfigService is started
   *
   * @param setupDeps
   */
  async registerRoutesAndHandlers(setupDeps) {
    const {
      http
    } = setupDeps;

    /**
     * TODO Register the routes
     *  - validate (needed for CP)
     *  - Optional:
     *    - create
     *    - bulkCreate
     *    - get
     *    - bulkGet
     *    - list
     *    - delete
     *    - bulkDelete
     */

    // FIXME: This seems not working as expected, as sometimes the context is not available to request handlers after registering
    //        in the PostAuth handler. Needs to do more research.
    //        For now, we can use DynamicConfigService.createStoreFromRequest(request) to create context store when it needs to
    //        fetch configrations from DynamicConfigStore.
    _classPrivateFieldGet(_logger, this).info('registering middleware to inject context to AsyncLocalStorage');
    http.registerOnPostAuth((request, response, context) => {
      if (request.auth.isAuthenticated) {
        const localStore = (0, _utils.createLocalStoreFromOsdRequest)(_classPrivateFieldGet(_logger, this), request, _classPrivateFieldGet(_requestHeaders, this));
        _classPrivateFieldGet(_asyncLocalStorage, this).enterWith(localStore);
      }
      return context.next();
    });
  }
  async stop() {}

  /**
   * Mimics Config Service schema registration, which should be finished calling before start() is called. Validation is not needed as the Config Service handles that
   *
   * @param path {string} the core ID, plugin ID, or the plugin configPath (if specified)
   * @param schema {Type<unknown>} the schema object defined in config.ts
   */
  setSchema(path, schema) {
    // Even though server configs are not pluginConfigPaths, the logic to parse the namespace will not change
    const namespace = (0, _utils.pathToString)({
      pluginConfigPath: path
    });
    if (_classPrivateFieldGet(_schemas, this).has(namespace)) {
      throw new Error(`Validation schema for [${namespace}] was already registered.`);
    }
    _classPrivateFieldGet(_schemas, this).set(namespace, schema);
  }

  /**
   * Checks if a certain config already exists
   *
   * @param configIdentifier {ConfigIdentifier} the core ID, plugin ID, or the plugin configPath (if specified)
   */
  hasDefaultConfigs(configIdentifier) {
    const namespace = (0, _utils.pathToString)(configIdentifier);
    return _classPrivateFieldGet(_schemas, this).has(namespace);
  }
}
exports.DynamicConfigService = DynamicConfigService;