/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.search;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.json.UnionDeserializer;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.TaggedUnion;
import org.opensearch.client.util.TaggedUnionUtils;

@JsonpDeserializable
public class TrackHits
implements TaggedUnion<Kind, Object>,
PlainJsonSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<TrackHits> _DESERIALIZER = JsonpDeserializer.lazy(TrackHits::buildTrackHitsDeserializer);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    private TrackHits(Kind kind, Object value) {
        this._kind = kind;
        this._value = value;
    }

    private TrackHits(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static TrackHits of(Function<Builder, ObjectBuilder<TrackHits>> fn) {
        return fn.apply(new Builder()).build();
    }

    public String _toJsonString() {
        switch (this._kind.ordinal()) {
            case 0: {
                return String.valueOf(this.count());
            }
            case 1: {
                return String.valueOf(this.enabled());
            }
        }
        throw new IllegalStateException("Unknown kind " + (Object)((Object)this._kind));
    }

    public boolean isCount() {
        return this._kind == Kind.Count;
    }

    public Integer count() {
        return (Integer)TaggedUnionUtils.get(this, Kind.Count);
    }

    public boolean isEnabled() {
        return this._kind == Kind.Enabled;
    }

    public Boolean enabled() {
        return (Boolean)TaggedUnionUtils.get(this, Kind.Enabled);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            switch (this._kind.ordinal()) {
                case 0: {
                    generator.write(((Integer)this._value).intValue());
                    break;
                }
                case 1: {
                    generator.write(((Boolean)this._value).booleanValue());
                }
            }
        }
    }

    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    private static JsonpDeserializer<TrackHits> buildTrackHitsDeserializer() {
        return new UnionDeserializer.Builder<TrackHits, Kind, Object>(TrackHits::new, false).addMember(Kind.Count, JsonpDeserializer.integerDeserializer()).addMember(Kind.Enabled, JsonpDeserializer.booleanDeserializer()).build();
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode((Object)this._kind);
        result = 31 * result + Objects.hashCode(this._value);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrackHits other = (TrackHits)o;
        return Objects.equals((Object)this._kind, (Object)other._kind) && Objects.equals(this._value, other._value);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<TrackHits> {
        private Kind _kind;
        private Object _value;

        public Builder() {
        }

        private Builder(TrackHits o) {
            this._kind = o._kind;
            this._value = o._value;
        }

        public ObjectBuilder<TrackHits> count(Integer v) {
            this._kind = Kind.Count;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TrackHits> enabled(Boolean v) {
            this._kind = Kind.Enabled;
            this._value = v;
            return this;
        }

        @Override
        public TrackHits build() {
            this._checkSingleUse();
            return new TrackHits(this);
        }
    }

    public static enum Kind {
        Count,
        Enabled;

    }
}

