/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.configuration;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.admin.cluster.shards.ClusterSearchShardsRequest;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.get.MultiGetItemResponse;
import org.opensearch.action.get.MultiGetRequest;
import org.opensearch.action.get.MultiGetResponse;
import org.opensearch.action.search.MultiSearchRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.document.DocumentField;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.index.IndexService;
import org.opensearch.index.get.GetResult;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.TermsQueryBuilder;
import org.opensearch.indices.IndicesService;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.security.privileges.DocumentAllowList;
import org.opensearch.security.privileges.PrivilegesEvaluationContext;
import org.opensearch.security.privileges.dlsfls.DlsRestriction;
import org.opensearch.security.privileges.dlsfls.DocumentPrivileges;
import org.opensearch.security.privileges.dlsfls.IndexToRuleMap;
import org.opensearch.security.queries.QueryBuilderTraverser;
import org.opensearch.security.resolver.IndexResolverReplacer;
import org.opensearch.security.support.ReflectiveAttributeAccessors;
import org.opensearch.security.util.ParentChildrenQueryDetector;
import org.opensearch.transport.client.Client;

public class DlsFilterLevelActionHandler {
    private static final Logger log = LogManager.getLogger(DlsFilterLevelActionHandler.class);
    private static final Function<SearchRequest, String> LOCAL_CLUSTER_ALIAS_GETTER = ReflectiveAttributeAccessors.protectedObjectAttr("localClusterAlias", String.class);
    private final String action;
    private final ActionRequest request;
    private final ActionListener<?> listener;
    private final IndexToRuleMap<DlsRestriction> dlsRestrictionMap;
    private final IndexResolverReplacer.Resolved resolved;
    private final boolean requiresIndexScoping;
    private final Client nodeClient;
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final ThreadContext threadContext;
    private final IndexNameExpressionResolver resolver;
    private BoolQueryBuilder filterLevelQueryBuilder;
    private DocumentAllowList documentAllowlist;

    public static boolean handle(PrivilegesEvaluationContext context, IndexToRuleMap<DlsRestriction> dlsRestrictionMap, ActionListener<?> listener, Client nodeClient, ClusterService clusterService, IndicesService indicesService, IndexNameExpressionResolver resolver, ThreadContext threadContext) {
        if (threadContext.getHeader("_opendistro_security_filter_level_dls_done") != null) {
            return true;
        }
        String action = context.getAction();
        ActionRequest request = context.getRequest();
        if (action.startsWith("cluster:") || action.startsWith("indices:admin/template/") || action.startsWith("indices:admin/index_template/")) {
            return true;
        }
        if (action.startsWith("indices:data/read/scroll")) {
            return true;
        }
        if (action.equals("indices:data/read/search/template") || action.equals("indices:data/read/msearch/template")) {
            return true;
        }
        if (request instanceof MultiSearchRequest) {
            return true;
        }
        return new DlsFilterLevelActionHandler(context, dlsRestrictionMap, listener, nodeClient, clusterService, indicesService, resolver, threadContext).handle();
    }

    DlsFilterLevelActionHandler(PrivilegesEvaluationContext context, IndexToRuleMap<DlsRestriction> dlsRestrictionMap, ActionListener<?> listener, Client nodeClient, ClusterService clusterService, IndicesService indicesService, IndexNameExpressionResolver resolver, ThreadContext threadContext) {
        this.action = context.getAction();
        this.request = context.getRequest();
        this.listener = listener;
        this.dlsRestrictionMap = dlsRestrictionMap;
        this.resolved = context.getResolvedRequest();
        this.nodeClient = nodeClient;
        this.clusterService = clusterService;
        this.indicesService = indicesService;
        this.threadContext = threadContext;
        this.resolver = resolver;
        this.requiresIndexScoping = this.resolved.isLocalAll() || this.resolved.getAllIndicesResolved(clusterService, resolver).size() != 1;
    }

    private boolean handle() {
        try (ThreadContext.StoredContext ctx = this.threadContext.newStoredContext(true);){
            block23: {
                this.threadContext.putHeader("_opendistro_security_filter_level_dls_done", this.request.toString());
                try {
                    if (this.modifyQuery()) break block23;
                    boolean bl = true;
                    return bl;
                }
                catch (Exception e) {
                    log.error("Unable to handle filter level DLS", (Throwable)e);
                    this.listener.onFailure((Exception)new OpenSearchSecurityException("Unable to handle filter level DLS", e, new Object[0]));
                    boolean bl = false;
                    if (ctx != null) {
                        ctx.close();
                    }
                    return bl;
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("Created filterLevelQuery for " + String.valueOf(this.request) + ":\n" + String.valueOf(this.filterLevelQueryBuilder));
            }
            if (this.filterLevelQueryBuilder == null) {
                boolean bl = true;
                return bl;
            }
            if (this.request instanceof SearchRequest) {
                boolean bl = this.handle((SearchRequest)this.request, ctx);
                return bl;
            }
            if (this.request instanceof GetRequest) {
                boolean bl = this.handle((GetRequest)this.request, ctx);
                return bl;
            }
            if (this.request instanceof MultiGetRequest) {
                boolean bl = this.handle((MultiGetRequest)this.request, ctx);
                return bl;
            }
            if (this.request instanceof ClusterSearchShardsRequest) {
                boolean bl = this.handle((ClusterSearchShardsRequest)this.request, ctx);
                return bl;
            }
            log.error("Unsupported request type for filter level DLS: " + String.valueOf(this.request));
            this.listener.onFailure((Exception)new OpenSearchSecurityException("Unsupported request type for filter level DLS: " + this.action + "; " + this.request.getClass().getName(), new Object[0]));
            boolean bl = false;
            return bl;
        }
    }

    private boolean handle(SearchRequest searchRequest, final ThreadContext.StoredContext ctx) {
        String localClusterAlias;
        if (this.documentAllowlist != null) {
            this.documentAllowlist.applyTo(this.threadContext);
        }
        if ((localClusterAlias = LOCAL_CLUSTER_ALIAS_GETTER.apply(searchRequest)) != null) {
            try {
                this.modifyQuery(localClusterAlias);
            }
            catch (Exception e) {
                log.error("Unable to handle filter level DLS", (Throwable)e);
                this.listener.onFailure((Exception)new OpenSearchSecurityException("Unable to handle filter level DLS", e, new Object[0]));
                return false;
            }
        }
        if (searchRequest.source().query() != null) {
            QueryBuilder query = searchRequest.source().query();
            if (ParentChildrenQueryDetector.hasParentOrChildQuery(query)) {
                this.listener.onFailure((Exception)new OpenSearchSecurityException("Unable to handle filter level DLS for parent or child queries", new Object[0]));
                return false;
            }
            this.filterLevelQueryBuilder.must(query);
        }
        searchRequest.source().query((QueryBuilder)this.filterLevelQueryBuilder);
        this.nodeClient.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

            public void onResponse(SearchResponse response) {
                try {
                    ctx.restore();
                    ActionListener<?> searchListener = DlsFilterLevelActionHandler.this.listener;
                    searchListener.onResponse((Object)response);
                }
                catch (Exception e) {
                    DlsFilterLevelActionHandler.this.listener.onFailure(e);
                }
            }

            public void onFailure(Exception e) {
                DlsFilterLevelActionHandler.this.listener.onFailure(e);
            }
        });
        return false;
    }

    private boolean handle(final GetRequest getRequest, final ThreadContext.StoredContext ctx) {
        if (this.documentAllowlist != null) {
            this.documentAllowlist.applyTo(this.threadContext);
        }
        final SearchRequest searchRequest = new SearchRequest(getRequest.indices());
        BoolQueryBuilder query = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.idsQuery().addIds(new String[]{getRequest.id()})).must((QueryBuilder)this.filterLevelQueryBuilder);
        searchRequest.source(SearchSourceBuilder.searchSource().query((QueryBuilder)query));
        this.nodeClient.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

            public void onResponse(SearchResponse response) {
                try {
                    ctx.restore();
                    long hits = Objects.requireNonNull(response.getHits().getTotalHits()).value();
                    ActionListener<?> getListener = DlsFilterLevelActionHandler.this.listener;
                    if (hits == 1L) {
                        getListener.onResponse((Object)new GetResponse(DlsFilterLevelActionHandler.this.searchHitToGetResult(response.getHits().getAt(0))));
                    } else if (hits == 0L) {
                        getListener.onResponse((Object)new GetResponse(new GetResult(searchRequest.indices()[0], getRequest.id(), -2L, 0L, -1L, false, null, null, null)));
                    } else {
                        log.error("Unexpected hit count " + hits + " in " + String.valueOf(response));
                        DlsFilterLevelActionHandler.this.listener.onFailure((Exception)new OpenSearchSecurityException("Internal error when performing DLS", new Object[0]));
                    }
                }
                catch (Exception e) {
                    DlsFilterLevelActionHandler.this.listener.onFailure(e);
                }
            }

            public void onFailure(Exception e) {
                DlsFilterLevelActionHandler.this.listener.onFailure(e);
            }
        });
        return false;
    }

    private boolean handle(MultiGetRequest multiGetRequest, final ThreadContext.StoredContext ctx) {
        BoolQueryBuilder query;
        if (this.documentAllowlist != null) {
            this.documentAllowlist.applyTo(this.threadContext);
        }
        Map idsGroupedByIndex = multiGetRequest.getItems().stream().collect(Collectors.groupingBy(item -> item.index(), Collectors.mapping(item -> item.id(), Collectors.toSet())));
        Set<String> indices = idsGroupedByIndex.keySet();
        SearchRequest searchRequest = new SearchRequest(indices.toArray(new String[indices.size()]));
        if (indices.size() == 1) {
            Set<String> ids = idsGroupedByIndex.get(indices.iterator().next());
            query = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.idsQuery().addIds(ids.toArray(new String[ids.size()]))).must((QueryBuilder)this.filterLevelQueryBuilder);
        } else {
            BoolQueryBuilder mgetQuery = QueryBuilders.boolQuery().minimumShouldMatch(1);
            for (Map.Entry entry : idsGroupedByIndex.entrySet()) {
                BoolQueryBuilder indexQuery = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"_index", (String)entry.getKey())).must((QueryBuilder)QueryBuilders.idsQuery().addIds(entry.getValue().toArray(new String[entry.getValue().size()])));
                mgetQuery.should((QueryBuilder)indexQuery);
            }
            query = QueryBuilders.boolQuery().must((QueryBuilder)mgetQuery).must((QueryBuilder)this.filterLevelQueryBuilder);
        }
        searchRequest.source(SearchSourceBuilder.searchSource().query((QueryBuilder)query));
        this.nodeClient.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

            public void onResponse(SearchResponse response) {
                try {
                    ctx.restore();
                    ArrayList<MultiGetItemResponse> itemResponses = new ArrayList<MultiGetItemResponse>(response.getHits().getHits().length);
                    for (SearchHit hit : response.getHits().getHits()) {
                        itemResponses.add(new MultiGetItemResponse(new GetResponse(DlsFilterLevelActionHandler.this.searchHitToGetResult(hit)), null));
                    }
                    ActionListener<?> multiGetListener = DlsFilterLevelActionHandler.this.listener;
                    multiGetListener.onResponse((Object)new MultiGetResponse(itemResponses.toArray(new MultiGetItemResponse[itemResponses.size()])));
                }
                catch (Exception e) {
                    DlsFilterLevelActionHandler.this.listener.onFailure(e);
                }
            }

            public void onFailure(Exception e) {
                DlsFilterLevelActionHandler.this.listener.onFailure(e);
            }
        });
        return false;
    }

    private boolean handle(ClusterSearchShardsRequest request, ThreadContext.StoredContext ctx) {
        this.listener.onFailure((Exception)new OpenSearchSecurityException("Filter-level DLS via cross cluster search is not available for scrolling and minimize_roundtrips=true", new Object[0]));
        return false;
    }

    private GetResult searchHitToGetResult(SearchHit hit) {
        Map<String, DocumentField> metadataFields;
        HashMap<String, DocumentField> documentFields;
        HashMap<String, DocumentField> fields;
        if (log.isDebugEnabled()) {
            log.debug("Converting to GetResult:\n" + String.valueOf(hit));
        }
        if ((fields = hit.getFields()).isEmpty()) {
            documentFields = Collections.emptyMap();
            metadataFields = Collections.emptyMap();
        } else {
            IndexService indexService;
            IndexMetadata indexMetadata = (IndexMetadata)this.clusterService.state().getMetadata().indices().get(hit.getIndex());
            IndexService indexService2 = indexService = indexMetadata != null ? this.indicesService.indexService(indexMetadata.getIndex()) : null;
            if (indexService != null) {
                documentFields = new HashMap<String, DocumentField>(fields.size());
                metadataFields = new HashMap();
                MapperService mapperService = indexService.mapperService();
                for (Map.Entry entry : fields.entrySet()) {
                    if (mapperService.isMetadataField((String)entry.getKey())) {
                        metadataFields.put((String)entry.getKey(), (DocumentField)entry.getValue());
                        continue;
                    }
                    documentFields.put((String)entry.getKey(), (DocumentField)entry.getValue());
                }
                if (log.isDebugEnabled()) {
                    log.debug("Partitioned fields: " + String.valueOf(metadataFields) + "; " + String.valueOf(documentFields));
                }
            } else {
                if (log.isWarnEnabled()) {
                    log.warn("Could not find IndexService for " + hit.getIndex() + "; assuming all fields as document fields.This should not happen, however this should also not pose a big problem as ES mixes the fields again anyway.\nIndexMetadata: " + String.valueOf(indexMetadata));
                }
                documentFields = fields;
                metadataFields = Collections.emptyMap();
            }
        }
        return new GetResult(hit.getIndex(), hit.getId(), hit.getSeqNo(), hit.getPrimaryTerm(), hit.getVersion(), true, hit.getSourceRef(), documentFields, metadataFields);
    }

    private boolean modifyQuery() throws IOException {
        return this.modifyQuery(null);
    }

    private boolean modifyQuery(String localClusterAlias) throws IOException {
        ImmutableMap<String, DlsRestriction> filterLevelQueries = this.dlsRestrictionMap.getIndexMap();
        BoolQueryBuilder dlsQueryBuilder = QueryBuilders.boolQuery().minimumShouldMatch(1);
        DocumentAllowList documentAllowlist = new DocumentAllowList();
        int queryCount = 0;
        Set<String> indices = this.resolved.getAllIndicesResolved(this.clusterService, this.resolver);
        for (String index : indices) {
            Object prefixedIndex = localClusterAlias != null ? localClusterAlias + ":" + index : index;
            DlsRestriction dlsRestriction = (DlsRestriction)filterLevelQueries.get(index);
            if (dlsRestriction == null || dlsRestriction.isUnrestricted()) {
                if (!this.requiresIndexScoping) continue;
                dlsQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"_index", (String)prefixedIndex));
                continue;
            }
            for (DocumentPrivileges.RenderedDlsQuery parsedDlsQuery : dlsRestriction.getQueries()) {
                ++queryCount;
                if (!this.requiresIndexScoping) {
                    dlsQueryBuilder.should(parsedDlsQuery.getQueryBuilder());
                } else {
                    dlsQueryBuilder.should((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"_index", (String)prefixedIndex)).must(parsedDlsQuery.getQueryBuilder()));
                }
                Set<QueryBuilder> queryBuilders = QueryBuilderTraverser.findAll(parsedDlsQuery.getQueryBuilder(), q -> q instanceof TermsQueryBuilder && ((TermsQueryBuilder)q).termsLookup() != null);
                for (QueryBuilder queryBuilder : queryBuilders) {
                    TermsQueryBuilder termsQueryBuilder = (TermsQueryBuilder)queryBuilder;
                    documentAllowlist.add(termsQueryBuilder.termsLookup().index(), termsQueryBuilder.termsLookup().id());
                }
            }
        }
        if (queryCount == 0) {
            return false;
        }
        this.filterLevelQueryBuilder = dlsQueryBuilder;
        this.documentAllowlist = documentAllowlist;
        return true;
    }
}

