/*
 * Decompiled with CFR 0.152.
 */
package com.plantuml.ubrex;

public enum LookAround {
    LOOK_AHEAD_POSITIVE("(=)"),
    LOOK_AHEAD_NEGATIVE("(!)"),
    LOOK_BEHIND_POSITIVE("(<=)"),
    LOOK_BEHIND_NEGATIVE("(<!)"),
    END_OF_TEXT("($)");

    private final String definition;

    private LookAround(String definition) {
        this.definition = definition;
    }

    public static LookAround from(CharSequence input) {
        char ch0 = input.charAt(0);
        char ch1 = input.charAt(1);
        if (ch0 != '(') {
            return null;
        }
        if (ch1 == '$') {
            return END_OF_TEXT;
        }
        if (ch1 == '=') {
            return LOOK_AHEAD_POSITIVE;
        }
        if (ch1 == '!') {
            return LOOK_AHEAD_NEGATIVE;
        }
        if (ch1 == '<') {
            char ch2 = input.charAt(2);
            if (ch2 == '=') {
                return LOOK_BEHIND_POSITIVE;
            }
            if (ch2 == '!') {
                return LOOK_BEHIND_NEGATIVE;
            }
        }
        return null;
    }

    public boolean isLookBehind() {
        switch (this.ordinal()) {
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public boolean isLookAhead() {
        switch (this.ordinal()) {
            case 0: 
            case 1: {
                return true;
            }
        }
        return false;
    }

    public int getDefinitionSize() {
        return this.definition.length();
    }
}

