/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc;

import java.lang.reflect.Executable;
import java.util.logging.Logger;
import oracle.jdbc.OracleConnectionStringBuilderImpl;

public interface OracleConnectionStringBuilder {
    public static final String SERVER_MODE_DEDICATED = "dedicated";
    public static final String SERVER_MODE_SHARED = "shared";
    public static final String SERVER_MODE_POOLED = "pooled";
    public static final String PROTOCOL_TCP = "TCP";
    public static final String PROTOCOL_TCPS = "TCPS";
    public static final String PROTOCOL_WSS = "WSS";

    public static OracleConnectionStringBuilder newInstance() {
        return new OracleConnectionStringBuilderImpl();
    }

    public OracleConnectionStringBuilder addConnectInfo(ConnectInfo var1);

    public OracleConnectionStringBuilder addConnectInfo(String var1, int var2);

    public OracleConnectionStringBuilder serviceName(String var1);

    public OracleConnectionStringBuilder serverMode(String var1);

    public OracleConnectionStringBuilder instanceName(String var1);

    public OracleConnectionStringBuilder serverDN(String var1);

    public OracleConnectionStringBuilder walletDirectory(String var1);

    public OracleConnectionStringBuilder loadBalance(boolean var1);

    public OracleConnectionStringBuilder connectTimeout(int var1);

    public OracleConnectionStringBuilder transportConnectTimeout(int var1);

    public OracleConnectionStringBuilder retryCount(int var1);

    public OracleConnectionStringBuilder retryDelay(int var1);

    public String build() throws IllegalStateException;

    public String buildThinStyleURL() throws IllegalStateException;

    public static class ConnectInfo {
        private String host;
        private int port;
        private String protocol = "TCP";
        private String proxyHost;
        private int proxyPort;
        private String webSocketURI;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;
        private static Executable $$$methodRef$$$9;
        private static Logger $$$loggerRef$$$9;
        private static Executable $$$methodRef$$$10;
        private static Logger $$$loggerRef$$$10;
        private static Executable $$$methodRef$$$11;
        private static Logger $$$loggerRef$$$11;
        private static Executable $$$methodRef$$$12;
        private static Logger $$$loggerRef$$$12;
        private static Executable $$$methodRef$$$13;
        private static Logger $$$loggerRef$$$13;
        private static Executable $$$methodRef$$$14;
        private static Logger $$$loggerRef$$$14;

        public static ConnectInfo newInstance() {
            return new ConnectInfo();
        }

        public ConnectInfo host(String host) {
            this.host = host;
            return this;
        }

        public ConnectInfo port(int port) {
            this.port = port;
            return this;
        }

        public ConnectInfo protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public ConnectInfo proxyHost(String proxyHost) {
            this.proxyHost = proxyHost;
            return this;
        }

        public ConnectInfo proxyPort(int proxyPort) {
            this.proxyPort = proxyPort;
            return this;
        }

        public ConnectInfo webSocketURI(String webSocketURI) {
            this.webSocketURI = webSocketURI;
            return this;
        }

        String getDbHostName() {
            return this.host;
        }

        int getDbPort() {
            return this.port;
        }

        String getProtocol() {
            return this.protocol;
        }

        String getProxyHost() {
            return this.proxyHost;
        }

        int getProxyPort() {
            return this.proxyPort;
        }

        String getWebSocketURI() {
            return this.webSocketURI;
        }

        void validate() throws IllegalStateException {
            if (this.host == null || this.host.isEmpty()) {
                throw new IllegalStateException("Host value cannot be empty");
            }
            if (this.port <= 0) {
                throw new IllegalStateException("Invalid port value : " + this.port);
            }
            if (this.protocol == null || this.protocol.isEmpty()) {
                throw new IllegalStateException("Invalid protocol : " + this.protocol);
            }
        }

        static {
            try {
                $$$methodRef$$$14 = ConnectInfo.class.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$13 = ConnectInfo.class.getDeclaredMethod("validate", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$12 = ConnectInfo.class.getDeclaredMethod("getWebSocketURI", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$11 = ConnectInfo.class.getDeclaredMethod("getProxyPort", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$10 = ConnectInfo.class.getDeclaredMethod("getProxyHost", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$9 = ConnectInfo.class.getDeclaredMethod("getProtocol", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$8 = ConnectInfo.class.getDeclaredMethod("getDbPort", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$7 = ConnectInfo.class.getDeclaredMethod("getDbHostName", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$6 = ConnectInfo.class.getDeclaredMethod("webSocketURI", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$5 = ConnectInfo.class.getDeclaredMethod("proxyPort", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = ConnectInfo.class.getDeclaredMethod("proxyHost", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = ConnectInfo.class.getDeclaredMethod("protocol", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = ConnectInfo.class.getDeclaredMethod("port", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = ConnectInfo.class.getDeclaredMethod("host", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = ConnectInfo.class.getDeclaredMethod("newInstance", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }
}

