/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.api;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.utilities.FinalBitSet;
import com.oracle.truffle.js.api.ValueLibrary;
import java.lang.invoke.MethodHandles;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=ValueLibrary.class)
final class ValueLibraryGen
extends LibraryFactory<ValueLibrary> {
    private static final Class<ValueLibrary> LIBRARY_CLASS = ValueLibraryGen.lazyLibraryClass();
    private static final Message IS_PROXY = new MessageImpl("isProxy", 0, false, Boolean.TYPE, Object.class);
    private static final Message IS_PROMISE = new MessageImpl("isPromise", 1, false, Boolean.TYPE, Object.class);
    private static final Message IS_ARRAY_BUFFER = new MessageImpl("isArrayBuffer", 2, false, Boolean.TYPE, Object.class);
    private static final Message TO_STRING = new MessageImpl("toString", 3, false, TruffleString.class, Object.class);
    private static final Message TO_NUMBER = new MessageImpl("toNumber", 4, false, Number.class, Object.class);
    private static final Message TO_BOOLEAN = new MessageImpl("toBoolean", 5, false, Boolean.TYPE, Object.class);
    private static final ValueLibraryGen INSTANCE = new ValueLibraryGen();
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private ValueLibraryGen() {
        super(LIBRARY_CLASS, List.of(IS_PROXY, IS_PROMISE, IS_ARRAY_BUFFER, TO_STRING, TO_NUMBER, TO_BOOLEAN));
    }

    protected Class<?> getDefaultClass(Object receiver) {
        return ValueLibrary.class;
    }

    protected MethodHandles.Lookup getLookup() {
        return MethodHandles.lookup();
    }

    protected ValueLibrary createProxy(ReflectionLibrary library) {
        return new Proxy(library);
    }

    protected FinalBitSet createMessageBitSet(Message ... messages) {
        BitSet bitSet = new BitSet(2);
        for (Message message : messages) {
            bitSet.set(message.getId());
        }
        return FinalBitSet.valueOf((BitSet)bitSet);
    }

    protected ValueLibrary createDelegate(ValueLibrary delegateLibrary) {
        return new Delegate(delegateLibrary);
    }

    protected Object genericDispatch(Library originalLib, Object receiver, Message message, Object[] args, int offset) throws Exception {
        ValueLibrary lib = (ValueLibrary)originalLib;
        if (message.getParameterCount() - 1 != args.length - offset) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Invalid number of arguments.");
        }
        switch (message.getId()) {
            case 0: {
                return lib.isProxy(receiver);
            }
            case 1: {
                return lib.isPromise(receiver);
            }
            case 2: {
                return lib.isArrayBuffer(receiver);
            }
            case 3: {
                return lib.toString(receiver);
            }
            case 4: {
                return lib.toNumber(receiver);
            }
            case 5: {
                return lib.toBoolean(receiver);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new AbstractMethodError(message.toString());
    }

    protected ValueLibrary createDispatchImpl(int limit) {
        return new CachedDispatchFirst(null, null, limit);
    }

    protected ValueLibrary createUncachedDispatch() {
        return new UncachedDispatch();
    }

    private static Class<ValueLibrary> lazyLibraryClass() {
        try {
            return Class.forName("com.oracle.truffle.js.api.ValueLibrary", false, ValueLibraryGen.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    static {
        LibraryExport.register(LIBRARY_CLASS, (LibraryExport[])new LibraryExport[]{new Default()});
        LibraryFactory.register(LIBRARY_CLASS, (LibraryFactory)INSTANCE);
    }

    @GeneratedBy(value=ValueLibrary.class)
    private static final class Proxy
    extends ValueLibrary {
        @Node.Child
        private ReflectionLibrary lib;

        Proxy(ReflectionLibrary lib) {
            this.lib = lib;
        }

        @Override
        public boolean isProxy(Object receiver_) {
            try {
                return (Boolean)this.lib.send(receiver_, IS_PROXY, new Object[0]);
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public boolean isPromise(Object receiver_) {
            try {
                return (Boolean)this.lib.send(receiver_, IS_PROMISE, new Object[0]);
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public boolean isArrayBuffer(Object receiver_) {
            try {
                return (Boolean)this.lib.send(receiver_, IS_ARRAY_BUFFER, new Object[0]);
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public TruffleString toString(Object receiver_) {
            try {
                return (TruffleString)this.lib.send(receiver_, TO_STRING, new Object[0]);
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public Number toNumber(Object receiver_) {
            try {
                return (Number)this.lib.send(receiver_, TO_NUMBER, new Object[0]);
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public boolean toBoolean(Object receiver_) {
            try {
                return (Boolean)this.lib.send(receiver_, TO_BOOLEAN, new Object[0]);
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        public boolean accepts(Object receiver_) {
            return this.lib.accepts(receiver_);
        }
    }

    @GeneratedBy(value=ValueLibrary.class)
    private static final class Delegate
    extends ValueLibrary {
        @Node.Child
        private ValueLibrary delegateLibrary;

        Delegate(ValueLibrary delegateLibrary) {
            this.delegateLibrary = delegateLibrary;
        }

        @Override
        public boolean isProxy(Object receiver_) {
            if (ValueLibraryGen.isDelegated((Library)this.delegateLibrary, (int)0)) {
                Object delegate = ValueLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((ValueLibrary)ValueLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).isProxy(delegate);
            }
            return this.delegateLibrary.isProxy(receiver_);
        }

        @Override
        public boolean isPromise(Object receiver_) {
            if (ValueLibraryGen.isDelegated((Library)this.delegateLibrary, (int)1)) {
                Object delegate = ValueLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((ValueLibrary)ValueLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).isPromise(delegate);
            }
            return this.delegateLibrary.isPromise(receiver_);
        }

        @Override
        public boolean isArrayBuffer(Object receiver_) {
            if (ValueLibraryGen.isDelegated((Library)this.delegateLibrary, (int)2)) {
                Object delegate = ValueLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((ValueLibrary)ValueLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).isArrayBuffer(delegate);
            }
            return this.delegateLibrary.isArrayBuffer(receiver_);
        }

        @Override
        public TruffleString toString(Object receiver_) {
            if (ValueLibraryGen.isDelegated((Library)this.delegateLibrary, (int)3)) {
                Object delegate = ValueLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((ValueLibrary)ValueLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).toString(delegate);
            }
            return this.delegateLibrary.toString(receiver_);
        }

        @Override
        public Number toNumber(Object receiver_) {
            if (ValueLibraryGen.isDelegated((Library)this.delegateLibrary, (int)4)) {
                Object delegate = ValueLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((ValueLibrary)ValueLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).toNumber(delegate);
            }
            return this.delegateLibrary.toNumber(receiver_);
        }

        @Override
        public boolean toBoolean(Object receiver_) {
            if (ValueLibraryGen.isDelegated((Library)this.delegateLibrary, (int)5)) {
                Object delegate = ValueLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((ValueLibrary)ValueLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).toBoolean(delegate);
            }
            return this.delegateLibrary.toBoolean(receiver_);
        }

        public boolean accepts(Object receiver_) {
            return this.delegateLibrary.accepts(receiver_);
        }

        public boolean isAdoptable() {
            return this.delegateLibrary.isAdoptable();
        }
    }

    @GeneratedBy(value=ValueLibrary.class)
    private static final class CachedDispatchFirst
    extends CachedDispatch {
        private final int limit_;

        CachedDispatchFirst(ValueLibrary library, CachedDispatch next, int limit_) {
            super(library, next);
            this.limit_ = limit_;
        }

        @Override
        int getLimit() {
            return this.limit_;
        }
    }

    @GeneratedBy(value=ValueLibrary.class)
    private static abstract class CachedDispatch
    extends ValueLibrary {
        @Node.Child
        ValueLibrary library;
        @Node.Child
        CachedDispatch next;

        CachedDispatch(ValueLibrary library, CachedDispatch next) {
            this.library = library;
            this.next = next;
        }

        abstract int getLimit();

        @Override
        @ExplodeLoop
        public boolean isProxy(Object receiver_) {
            while (true) {
                CachedDispatch current = this;
                do {
                    ValueLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.isProxy(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public boolean isPromise(Object receiver_) {
            while (true) {
                CachedDispatch current = this;
                do {
                    ValueLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.isPromise(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public boolean isArrayBuffer(Object receiver_) {
            while (true) {
                CachedDispatch current = this;
                do {
                    ValueLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.isArrayBuffer(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public TruffleString toString(Object receiver_) {
            while (true) {
                CachedDispatch current = this;
                do {
                    ValueLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.toString(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public Number toNumber(Object receiver_) {
            while (true) {
                CachedDispatch current = this;
                do {
                    ValueLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.toNumber(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public boolean toBoolean(Object receiver_) {
            while (true) {
                CachedDispatch current = this;
                do {
                    ValueLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.toBoolean(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        public boolean accepts(Object receiver_) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void specialize(Object receiver_) {
            Lock lock = this.getLock();
            lock.lock();
            try {
                CachedDispatch current = this;
                ValueLibrary thisLibrary = current.library;
                if (thisLibrary == null) {
                    this.library = (ValueLibrary)this.insert((Node)((ValueLibrary)INSTANCE.create(receiver_)));
                } else {
                    int count = 0;
                    do {
                        ValueLibrary currentLibrary;
                        if ((currentLibrary = current.library) != null && currentLibrary.accepts(receiver_)) {
                            return;
                        }
                        ++count;
                    } while ((current = current.next) != null);
                    if (count >= this.getLimit()) {
                        this.library = (ValueLibrary)this.insert((Node)new CachedToUncachedDispatch());
                        this.next = null;
                    } else {
                        this.next = (CachedDispatch)this.insert((Node)new CachedDispatchNext((ValueLibrary)INSTANCE.create(receiver_), this.next));
                    }
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    @GeneratedBy(value=ValueLibrary.class)
    @DenyReplace
    private static final class UncachedDispatch
    extends ValueLibrary
    implements UnadoptableNode {
        private UncachedDispatch() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean isProxy(Object receiver_) {
            return ((ValueLibrary)INSTANCE.getUncached(receiver_)).isProxy(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean isPromise(Object receiver_) {
            return ((ValueLibrary)INSTANCE.getUncached(receiver_)).isPromise(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean isArrayBuffer(Object receiver_) {
            return ((ValueLibrary)INSTANCE.getUncached(receiver_)).isArrayBuffer(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public TruffleString toString(Object receiver_) {
            return ((ValueLibrary)INSTANCE.getUncached(receiver_)).toString(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Number toNumber(Object receiver_) {
            return ((ValueLibrary)INSTANCE.getUncached(receiver_)).toNumber(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean toBoolean(Object receiver_) {
            return ((ValueLibrary)INSTANCE.getUncached(receiver_)).toBoolean(receiver_);
        }

        @CompilerDirectives.TruffleBoundary
        public boolean accepts(Object receiver_) {
            return true;
        }
    }

    @GeneratedBy(value=ValueLibrary.class)
    private static class MessageImpl
    extends Message {
        MessageImpl(String name, int index, boolean deprecated, Class<?> returnType, Class<?> ... parameters) {
            super(LIBRARY_CLASS, name, index, deprecated, returnType, (Class[])parameters);
        }
    }

    @GeneratedBy(value=ValueLibrary.class)
    private static final class Default
    extends LibraryExport<ValueLibrary> {
        private Default() {
            super(ValueLibrary.class, Object.class, false, false, 0);
        }

        protected ValueLibrary createUncached(Object receiver) {
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected ValueLibrary createCached(Object receiver) {
            return new Cached(receiver);
        }

        @GeneratedBy(value=ValueLibrary.class)
        @DenyReplace
        private static final class Uncached
        extends ValueLibrary
        implements UnadoptableNode {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Uncached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
                this.dynamicDispatchTarget_ = this.dynamicDispatch_.dispatch(receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == this.dynamicDispatchTarget_;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isProxy(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.isProxy(receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isPromise(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.isPromise(receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isArrayBuffer(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.isArrayBuffer(receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public TruffleString toString(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.toString(receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Number toNumber(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.toNumber(receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean toBoolean(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.toBoolean(receiver);
            }
        }

        @GeneratedBy(value=ValueLibrary.class)
        private static final class Cached
        extends ValueLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Cached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)this.insert((Node)((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.create(receiver)));
                this.dynamicDispatchTarget_ = ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver)).dispatch(receiver);
            }

            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == this.dynamicDispatchTarget_;
            }

            @Override
            public boolean isProxy(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.isProxy(this.dynamicDispatch_.cast(receiver));
            }

            @Override
            public boolean isPromise(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.isPromise(this.dynamicDispatch_.cast(receiver));
            }

            @Override
            public boolean isArrayBuffer(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.isArrayBuffer(this.dynamicDispatch_.cast(receiver));
            }

            @Override
            public TruffleString toString(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.toString(this.dynamicDispatch_.cast(receiver));
            }

            @Override
            public Number toNumber(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.toNumber(this.dynamicDispatch_.cast(receiver));
            }

            @Override
            public boolean toBoolean(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.toBoolean(this.dynamicDispatch_.cast(receiver));
            }
        }
    }

    @GeneratedBy(value=ValueLibrary.class)
    private static final class CachedDispatchNext
    extends CachedDispatch {
        CachedDispatchNext(ValueLibrary library, CachedDispatch next) {
            super(library, next);
        }

        @Override
        int getLimit() {
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    @GeneratedBy(value=ValueLibrary.class)
    private static final class CachedToUncachedDispatch
    extends ValueLibrary {
        private CachedToUncachedDispatch() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean isProxy(Object receiver_) {
            assert (ValueLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                boolean bl = ((ValueLibrary)INSTANCE.getUncached(receiver_)).isProxy(receiver_);
                return bl;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean isPromise(Object receiver_) {
            assert (ValueLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                boolean bl = ((ValueLibrary)INSTANCE.getUncached(receiver_)).isPromise(receiver_);
                return bl;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean isArrayBuffer(Object receiver_) {
            assert (ValueLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                boolean bl = ((ValueLibrary)INSTANCE.getUncached(receiver_)).isArrayBuffer(receiver_);
                return bl;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public TruffleString toString(Object receiver_) {
            assert (ValueLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                TruffleString truffleString = ((ValueLibrary)INSTANCE.getUncached(receiver_)).toString(receiver_);
                return truffleString;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Number toNumber(Object receiver_) {
            assert (ValueLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                Number number = ((ValueLibrary)INSTANCE.getUncached(receiver_)).toNumber(receiver_);
                return number;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean toBoolean(Object receiver_) {
            assert (ValueLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                boolean bl = ((ValueLibrary)INSTANCE.getUncached(receiver_)).toBoolean(receiver_);
                return bl;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        public boolean accepts(Object receiver_) {
            return true;
        }
    }
}

