/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.util.concurrent.atomic.LongAdder;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FilterCollector;
import org.apache.lucene.search.FilterLeafCollector;
import org.apache.lucene.search.LeafCollector;
import org.apache.solr.search.EarlyTerminatingCollectorException;

public class EarlyTerminatingCollector
extends FilterCollector {
    private final int chunkSize;
    private final int maxDocsToCollect;
    private int numCollectedLocally = 0;
    private int prevReaderCumulativeSize = 0;
    private int currentReaderSize = 0;
    private final LongAdder pendingDocsToCollect;
    private boolean terminatedEarly = false;

    public EarlyTerminatingCollector(Collector delegate, int maxDocsToCollect) {
        this(delegate, maxDocsToCollect, null);
    }

    public EarlyTerminatingCollector(Collector delegate, int maxDocsToCollect, LongAdder docsToCollect) {
        super(delegate);
        assert (0 < maxDocsToCollect);
        assert (null != delegate);
        this.maxDocsToCollect = maxDocsToCollect;
        this.pendingDocsToCollect = docsToCollect;
        this.chunkSize = Math.min(100, maxDocsToCollect / 10);
    }

    public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
        this.prevReaderCumulativeSize += this.currentReaderSize;
        this.currentReaderSize = context.reader().maxDoc();
        return new FilterLeafCollector(super.getLeafCollector(context)){

            public void collect(int doc) throws IOException {
                super.collect(doc);
                ++EarlyTerminatingCollector.this.numCollectedLocally;
                boolean bl = EarlyTerminatingCollector.this.terminatedEarly = EarlyTerminatingCollector.this.numCollectedLocally >= EarlyTerminatingCollector.this.maxDocsToCollect;
                if (EarlyTerminatingCollector.this.pendingDocsToCollect != null) {
                    EarlyTerminatingCollector.this.pendingDocsToCollect.increment();
                    if (EarlyTerminatingCollector.this.numCollectedLocally % EarlyTerminatingCollector.this.chunkSize == 0) {
                        long overallCollectedDocCount = EarlyTerminatingCollector.this.pendingDocsToCollect.intValue();
                        boolean bl2 = EarlyTerminatingCollector.this.terminatedEarly = overallCollectedDocCount >= (long)EarlyTerminatingCollector.this.maxDocsToCollect;
                    }
                }
                if (EarlyTerminatingCollector.this.terminatedEarly) {
                    throw new EarlyTerminatingCollectorException(EarlyTerminatingCollector.this.maxDocsToCollect, EarlyTerminatingCollector.this.prevReaderCumulativeSize + (doc + 1));
                }
            }
        };
    }

    public Collector getDelegate() {
        return this.in;
    }
}

