/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.routing;

import java.util.ArrayList;
import java.util.List;
import org.apache.solr.common.util.StrUtils;

public class PreferenceRule {
    public final String name;
    public final String value;

    public PreferenceRule(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public static List<PreferenceRule> from(String rules) {
        List<String> prefs = StrUtils.splitSmart(rules, ',');
        ArrayList<PreferenceRule> preferenceRules = new ArrayList<PreferenceRule>(prefs.size());
        prefs.forEach(rule -> {
            String[] parts = rule.split(":", 2);
            if (parts.length != 2) {
                throw new IllegalArgumentException("Invalid shards.preference rule: " + rule);
            }
            preferenceRules.add(new PreferenceRule(parts[0], parts[1]));
        });
        return preferenceRules;
    }

    public String toString() {
        return this.name + ":" + this.value;
    }
}

